/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.PasswordTokensRequest;
import org.projectnessie.client.auth.oauth2.TokensRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PasswordTokensRequest", generator="Immutables")
@Immutable
final class ImmutablePasswordTokensRequest
implements PasswordTokensRequest {
    @Nullable
    private final String scope;
    private final String grantType;
    private final String username;
    private final String password;

    private ImmutablePasswordTokensRequest(Builder builder) {
        this.scope = builder.scope;
        this.username = builder.username;
        this.password = builder.password;
        this.grantType = builder.grantType != null ? builder.grantType : Objects.requireNonNull(PasswordTokensRequest.super.getGrantType(), "grantType");
    }

    private ImmutablePasswordTokensRequest(@Nullable String scope, String grantType, String username, String password) {
        this.scope = scope;
        this.grantType = grantType;
        this.username = username;
        this.password = password;
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="grant_type")
    public String getGrantType() {
        return this.grantType;
    }

    @Override
    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    @Override
    @JsonProperty(value="password")
    public String getPassword() {
        return this.password;
    }

    public final ImmutablePasswordTokensRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutablePasswordTokensRequest(value, this.grantType, this.username, this.password);
    }

    public final ImmutablePasswordTokensRequest withGrantType(String value) {
        String newValue = Objects.requireNonNull(value, "grantType");
        if (this.grantType.equals(newValue)) {
            return this;
        }
        return new ImmutablePasswordTokensRequest(this.scope, newValue, this.username, this.password);
    }

    public final ImmutablePasswordTokensRequest withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutablePasswordTokensRequest(this.scope, this.grantType, newValue, this.password);
    }

    public final ImmutablePasswordTokensRequest withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (this.password.equals(newValue)) {
            return this;
        }
        return new ImmutablePasswordTokensRequest(this.scope, this.grantType, this.username, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePasswordTokensRequest && this.equalTo(0, (ImmutablePasswordTokensRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutablePasswordTokensRequest another) {
        return Objects.equals(this.scope, another.scope) && this.grantType.equals(another.grantType) && this.username.equals(another.username) && this.password.equals(another.password);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.scope);
        h2 += (h2 << 5) + this.grantType.hashCode();
        h2 += (h2 << 5) + this.username.hashCode();
        h2 += (h2 << 5) + this.password.hashCode();
        return h2;
    }

    public String toString() {
        return "PasswordTokensRequest{scope=" + this.scope + ", grantType=" + this.grantType + ", username=" + this.username + ", password=" + this.password + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePasswordTokensRequest fromJson(Json json) {
        Builder builder = ImmutablePasswordTokensRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.grantType != null) {
            builder.grantType(json.grantType);
        }
        if (json.username != null) {
            builder.username(json.username);
        }
        if (json.password != null) {
            builder.password(json.password);
        }
        return builder.build();
    }

    public static ImmutablePasswordTokensRequest copyOf(PasswordTokensRequest instance) {
        if (instance instanceof ImmutablePasswordTokensRequest) {
            return (ImmutablePasswordTokensRequest)instance;
        }
        return ImmutablePasswordTokensRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PasswordTokensRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private static final long INIT_BIT_PASSWORD = 2L;
        private long initBits = 3L;
        @Nullable
        private String scope;
        @Nullable
        private String grantType;
        @Nullable
        private String username;
        @Nullable
        private String password;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TokensRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(PasswordTokensRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            String scopeValue;
            TokensRequestBase instance;
            long bits = 0L;
            if (object instanceof TokensRequestBase) {
                instance = (TokensRequestBase)object;
                if ((bits & 2L) == 0L) {
                    this.grantType(instance.getGrantType());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof PasswordTokensRequest) {
                instance = (PasswordTokensRequest)object;
                this.password(instance.getPassword());
                if ((bits & 2L) == 0L) {
                    this.grantType(instance.getGrantType());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
                this.username(instance.getUsername());
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="grant_type")
        @CanIgnoreReturnValue
        public final Builder grantType(String grantType) {
            this.grantType = Objects.requireNonNull(grantType, "grantType");
            return this;
        }

        @JsonProperty(value="username")
        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="password")
        @CanIgnoreReturnValue
        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePasswordTokensRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePasswordTokensRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("password");
            }
            return "Cannot build PasswordTokensRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="PasswordTokensRequest", generator="Immutables")
    static final class Json
    implements PasswordTokensRequest {
        @Nullable
        String scope;
        @Nullable
        String grantType;
        @Nullable
        String username;
        @Nullable
        String password;

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @JsonProperty(value="grant_type")
        public void setGrantType(String grantType) {
            this.grantType = grantType;
        }

        @JsonProperty(value="username")
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty(value="password")
        public void setPassword(String password) {
            this.password = password;
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGrantType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPassword() {
            throw new UnsupportedOperationException();
        }
    }
}

