/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.function.Supplier;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class RollingManifestWriter<F extends ContentFile<F>>
implements Closeable {
    private static final int ROWS_DIVISOR = 250;
    private final Supplier<ManifestWriter<F>> manifestWriterSupplier;
    private final long targetFileSizeInBytes;
    private final List<ManifestFile> manifestFiles;
    private long currentFileRows = 0L;
    private ManifestWriter<F> currentWriter = null;
    private boolean closed = false;

    public RollingManifestWriter(Supplier<ManifestWriter<F>> manifestWriterSupplier, long targetFileSizeInBytes) {
        this.manifestWriterSupplier = manifestWriterSupplier;
        this.targetFileSizeInBytes = targetFileSizeInBytes;
        this.manifestFiles = Lists.newArrayList();
    }

    public void add(F addedFile) {
        this.currentWriter().add(addedFile);
        ++this.currentFileRows;
    }

    public void add(F addedFile, long dataSequenceNumber) {
        this.currentWriter().add(addedFile, dataSequenceNumber);
        ++this.currentFileRows;
    }

    public void existing(F existingFile, long fileSnapshotId, long dataSequenceNumber, Long fileSequenceNumber) {
        this.currentWriter().existing(existingFile, fileSnapshotId, dataSequenceNumber, fileSequenceNumber);
        ++this.currentFileRows;
    }

    public void delete(F deletedFile, long dataSequenceNumber, Long fileSequenceNumber) {
        this.currentWriter().delete(deletedFile, dataSequenceNumber, fileSequenceNumber);
        ++this.currentFileRows;
    }

    private ManifestWriter<F> currentWriter() {
        if (this.currentWriter == null) {
            this.currentWriter = this.manifestWriterSupplier.get();
        } else if (this.shouldRollToNewFile()) {
            this.closeCurrentWriter();
            this.currentWriter = this.manifestWriterSupplier.get();
        }
        return this.currentWriter;
    }

    private boolean shouldRollToNewFile() {
        return this.currentFileRows % 250L == 0L && this.currentWriter.length() >= this.targetFileSizeInBytes;
    }

    private void closeCurrentWriter() {
        if (this.currentWriter != null) {
            try {
                this.currentWriter.close();
                ManifestFile currentFile = this.currentWriter.toManifestFile();
                this.manifestFiles.add(currentFile);
                this.currentWriter = null;
                this.currentFileRows = 0L;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to close current writer", e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closeCurrentWriter();
            this.closed = true;
        }
    }

    public List<ManifestFile> toManifestFiles() {
        Preconditions.checkState(this.closed, "Cannot get ManifestFile list from unclosed writer");
        return this.manifestFiles;
    }
}

