/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws;

import java.net.URI;
import java.util.Map;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.aws.AwsClientProperties;
import org.apache.iceberg.aws.AwsProperties;
import org.apache.iceberg.aws.HttpClientProperties;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.util.PropertyUtil;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.client.builder.SdkClientBuilder;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.urlconnection.UrlConnectionHttpClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClientBuilder;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.GlueClientBuilder;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.KmsClientBuilder;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;

public class AwsClientFactories {
    private static final DefaultAwsClientFactory AWS_CLIENT_FACTORY_DEFAULT = new DefaultAwsClientFactory();

    private AwsClientFactories() {
    }

    public static AwsClientFactory defaultFactory() {
        return AWS_CLIENT_FACTORY_DEFAULT;
    }

    public static AwsClientFactory from(Map<String, String> properties) {
        String factoryImpl = PropertyUtil.propertyAsString(properties, "client.factory", DefaultAwsClientFactory.class.getName());
        return AwsClientFactories.loadClientFactory(factoryImpl, properties);
    }

    private static AwsClientFactory loadClientFactory(String impl, Map<String, String> properties) {
        AwsClientFactory factory;
        DynConstructors.Ctor ctor;
        try {
            ctor = DynConstructors.builder(AwsClientFactory.class).loader(AwsClientFactories.class.getClassLoader()).hiddenImpl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize AwsClientFactory, missing no-arg constructor: %s", impl), e);
        }
        try {
            factory = (AwsClientFactory)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize AwsClientFactory, %s does not implement AwsClientFactory.", impl), e);
        }
        factory.initialize(properties);
        return factory;
    }

    @Deprecated
    public static SdkHttpClient.Builder configureHttpClientBuilder(String httpClientType) {
        String clientType = httpClientType;
        if (Strings.isNullOrEmpty(clientType)) {
            clientType = "apache";
        }
        switch (clientType) {
            case "urlconnection": {
                return UrlConnectionHttpClient.builder();
            }
            case "apache": {
                return ApacheHttpClient.builder();
            }
        }
        throw new IllegalArgumentException("Unrecognized HTTP client type " + httpClientType);
    }

    @Deprecated
    public static <T extends SdkClientBuilder> void configureEndpoint(T builder, String endpoint) {
        if (endpoint != null) {
            builder.endpointOverride(URI.create(endpoint));
        }
    }

    @Deprecated
    public static S3Configuration s3Configuration(Boolean pathStyleAccess, Boolean s3UseArnRegionEnabled) {
        return (S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(pathStyleAccess).useArnRegionEnabled(s3UseArnRegionEnabled).build();
    }

    @Deprecated
    static AwsCredentialsProvider credentialsProvider(String accessKeyId, String secretAccessKey, String sessionToken) {
        if (accessKeyId != null) {
            if (sessionToken == null) {
                return StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKeyId, (String)secretAccessKey));
            }
            return StaticCredentialsProvider.create((AwsCredentials)AwsSessionCredentials.create((String)accessKeyId, (String)secretAccessKey, (String)sessionToken));
        }
        return DefaultCredentialsProvider.builder().build();
    }

    static class DefaultAwsClientFactory
    implements AwsClientFactory {
        private AwsProperties awsProperties = new AwsProperties();
        private AwsClientProperties awsClientProperties = new AwsClientProperties();
        private S3FileIOProperties s3FileIOProperties = new S3FileIOProperties();
        private HttpClientProperties httpClientProperties = new HttpClientProperties();

        DefaultAwsClientFactory() {
        }

        @Override
        public S3Client s3() {
            return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().applyMutation(this.awsClientProperties::applyClientRegionConfiguration)).applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).applyMutation(this.s3FileIOProperties::applyEndpointConfigurations)).applyMutation(this.s3FileIOProperties::applyServiceConfigurations)).applyMutation(b -> this.s3FileIOProperties.applyCredentialConfigurations(this.awsClientProperties, b))).applyMutation(this.s3FileIOProperties::applySignerConfiguration)).build();
        }

        @Override
        public GlueClient glue() {
            return (GlueClient)((GlueClientBuilder)((GlueClientBuilder)((GlueClientBuilder)((GlueClientBuilder)GlueClient.builder().applyMutation(this.awsClientProperties::applyClientRegionConfiguration)).applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).applyMutation(this.awsProperties::applyGlueEndpointConfigurations)).applyMutation(this.awsProperties::applyClientCredentialConfigurations)).build();
        }

        @Override
        public KmsClient kms() {
            return (KmsClient)((KmsClientBuilder)((KmsClientBuilder)((KmsClientBuilder)KmsClient.builder().applyMutation(this.awsClientProperties::applyClientRegionConfiguration)).applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).applyMutation(this.awsProperties::applyClientCredentialConfigurations)).build();
        }

        @Override
        public DynamoDbClient dynamo() {
            return (DynamoDbClient)((DynamoDbClientBuilder)((DynamoDbClientBuilder)((DynamoDbClientBuilder)((DynamoDbClientBuilder)DynamoDbClient.builder().applyMutation(this.awsClientProperties::applyClientRegionConfiguration)).applyMutation(this.httpClientProperties::applyHttpClientConfigurations)).applyMutation(this.awsProperties::applyClientCredentialConfigurations)).applyMutation(this.awsProperties::applyDynamoDbEndpointConfigurations)).build();
        }

        @Override
        public void initialize(Map<String, String> properties) {
            this.awsProperties = new AwsProperties(properties);
            this.awsClientProperties = new AwsClientProperties(properties);
            this.s3FileIOProperties = new S3FileIOProperties(properties);
            this.httpClientProperties = new HttpClientProperties(properties);
        }
    }
}

