/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.catalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.UpdateRequirement;
import org.apache.iceberg.catalog.TableCommit;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TableCommit", generator="Immutables")
@Immutable
public final class ImmutableTableCommit
implements TableCommit {
    private final TableIdentifier identifier;
    private final List<UpdateRequirement> requirements;
    private final List<MetadataUpdate> updates;

    private ImmutableTableCommit(TableIdentifier identifier, List<UpdateRequirement> requirements, List<MetadataUpdate> updates) {
        this.identifier = identifier;
        this.requirements = requirements;
        this.updates = updates;
    }

    @Override
    public TableIdentifier identifier() {
        return this.identifier;
    }

    @Override
    public List<UpdateRequirement> requirements() {
        return this.requirements;
    }

    @Override
    public List<MetadataUpdate> updates() {
        return this.updates;
    }

    public final ImmutableTableCommit withIdentifier(TableIdentifier value) {
        if (this.identifier == value) {
            return this;
        }
        TableIdentifier newValue = Objects.requireNonNull(value, "identifier");
        return new ImmutableTableCommit(newValue, this.requirements, this.updates);
    }

    public final ImmutableTableCommit withRequirements(UpdateRequirement ... elements) {
        List<UpdateRequirement> newValue = ImmutableTableCommit.createUnmodifiableList(false, ImmutableTableCommit.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTableCommit(this.identifier, newValue, this.updates);
    }

    public final ImmutableTableCommit withRequirements(Iterable<? extends UpdateRequirement> elements) {
        if (this.requirements == elements) {
            return this;
        }
        List<UpdateRequirement> newValue = ImmutableTableCommit.createUnmodifiableList(false, ImmutableTableCommit.createSafeList(elements, true, false));
        return new ImmutableTableCommit(this.identifier, newValue, this.updates);
    }

    public final ImmutableTableCommit withUpdates(MetadataUpdate ... elements) {
        List<MetadataUpdate> newValue = ImmutableTableCommit.createUnmodifiableList(false, ImmutableTableCommit.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableTableCommit(this.identifier, this.requirements, newValue);
    }

    public final ImmutableTableCommit withUpdates(Iterable<? extends MetadataUpdate> elements) {
        if (this.updates == elements) {
            return this;
        }
        List<MetadataUpdate> newValue = ImmutableTableCommit.createUnmodifiableList(false, ImmutableTableCommit.createSafeList(elements, true, false));
        return new ImmutableTableCommit(this.identifier, this.requirements, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTableCommit && this.equalTo(0, (ImmutableTableCommit)another);
    }

    private boolean equalTo(int synthetic, ImmutableTableCommit another) {
        return this.identifier.equals(another.identifier) && this.requirements.equals(another.requirements) && this.updates.equals(another.updates);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.identifier.hashCode();
        h2 += (h2 << 5) + this.requirements.hashCode();
        h2 += (h2 << 5) + this.updates.hashCode();
        return h2;
    }

    public String toString() {
        return "TableCommit{identifier=" + this.identifier + ", requirements=" + this.requirements + ", updates=" + this.updates + "}";
    }

    public static ImmutableTableCommit copyOf(TableCommit instance) {
        if (instance instanceof ImmutableTableCommit) {
            return (ImmutableTableCommit)instance;
        }
        return ImmutableTableCommit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="TableCommit", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        @Nullable
        private TableIdentifier identifier;
        private List<UpdateRequirement> requirements = new ArrayList<UpdateRequirement>();
        private List<MetadataUpdate> updates = new ArrayList<MetadataUpdate>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TableCommit instance) {
            Objects.requireNonNull(instance, "instance");
            this.identifier(instance.identifier());
            this.addAllRequirements(instance.requirements());
            this.addAllUpdates(instance.updates());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder identifier(TableIdentifier identifier) {
            this.identifier = Objects.requireNonNull(identifier, "identifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequirements(UpdateRequirement element) {
            this.requirements.add(Objects.requireNonNull(element, "requirements element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRequirements(UpdateRequirement ... elements) {
            for (UpdateRequirement element : elements) {
                this.requirements.add(Objects.requireNonNull(element, "requirements element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder requirements(Iterable<? extends UpdateRequirement> elements) {
            this.requirements.clear();
            return this.addAllRequirements(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRequirements(Iterable<? extends UpdateRequirement> elements) {
            for (UpdateRequirement updateRequirement : elements) {
                this.requirements.add(Objects.requireNonNull(updateRequirement, "requirements element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUpdates(MetadataUpdate element) {
            this.updates.add(Objects.requireNonNull(element, "updates element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUpdates(MetadataUpdate ... elements) {
            for (MetadataUpdate element : elements) {
                this.updates.add(Objects.requireNonNull(element, "updates element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder updates(Iterable<? extends MetadataUpdate> elements) {
            this.updates.clear();
            return this.addAllUpdates(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllUpdates(Iterable<? extends MetadataUpdate> elements) {
            for (MetadataUpdate metadataUpdate : elements) {
                this.updates.add(Objects.requireNonNull(metadataUpdate, "updates element"));
            }
            return this;
        }

        public ImmutableTableCommit build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTableCommit(this.identifier, ImmutableTableCommit.createUnmodifiableList(true, this.requirements), ImmutableTableCommit.createUnmodifiableList(true, this.updates));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("identifier");
            }
            return "Cannot build TableCommit, some of required attributes are not set " + attributes;
        }
    }
}

