/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.gcs;

import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.gcp.GCPProperties;
import org.apache.iceberg.gcp.gcs.BaseGCSFile;
import org.apache.iceberg.gcp.gcs.GCSInputFile;
import org.apache.iceberg.gcp.gcs.GCSOutputStream;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.metrics.MetricsContext;

class GCSOutputFile
extends BaseGCSFile
implements OutputFile {
    static GCSOutputFile fromLocation(String location, Storage storage, GCPProperties gcpProperties, MetricsContext metrics) {
        return new GCSOutputFile(storage, BlobId.fromGsUtilUri((String)location), gcpProperties, metrics);
    }

    GCSOutputFile(Storage storage, BlobId blobId, GCPProperties gcpProperties, MetricsContext metrics) {
        super(storage, blobId, gcpProperties, metrics);
    }

    @Override
    public PositionOutputStream create() {
        if (!this.exists()) {
            return this.createOrOverwrite();
        }
        throw new AlreadyExistsException("Location already exists: %s", this.uri());
    }

    @Override
    public PositionOutputStream createOrOverwrite() {
        try {
            return new GCSOutputStream(this.storage(), this.blobId(), this.gcpProperties(), this.metrics());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to create output stream for location: " + this.uri(), e);
        }
    }

    @Override
    public InputFile toInputFile() {
        return new GCSInputFile(this.storage(), this.blobId(), null, this.gcpProperties(), this.metrics());
    }
}

