/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.sql.Date;
import java.time.LocalDate;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.mr.hive.serde.objectinspector.WriteObjectInspector;
import org.apache.iceberg.util.DateTimeUtil;

public final class IcebergDateObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements DateObjectInspector,
WriteObjectInspector {
    private static final IcebergDateObjectInspector INSTANCE = new IcebergDateObjectInspector();

    public static IcebergDateObjectInspector get() {
        return INSTANCE;
    }

    private IcebergDateObjectInspector() {
        super(TypeInfoFactory.dateTypeInfo);
    }

    public Date getPrimitiveJavaObject(Object o) {
        return o == null ? null : Date.valueOf((LocalDate)o);
    }

    public DateWritable getPrimitiveWritableObject(Object o) {
        return o == null ? null : new DateWritable(DateTimeUtil.daysFromDate((LocalDate)o));
    }

    public Object copyObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return new Date(((Date)o).getTime());
        }
        if (o instanceof LocalDate) {
            return LocalDate.of(((LocalDate)o).getYear(), ((LocalDate)o).getMonth(), ((LocalDate)o).getDayOfMonth());
        }
        return o;
    }

    @Override
    public LocalDate convert(Object o) {
        return o == null ? null : ((Date)o).toLocalDate();
    }
}

