/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.nessie;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableCommitMeta;
import org.projectnessie.model.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NessieUtil {
    private static final Logger LOG = LoggerFactory.getLogger(NessieUtil.class);
    public static final String NESSIE_CONFIG_PREFIX = "nessie.";
    static final String APPLICATION_TYPE = "application-type";
    public static final String CLIENT_API_VERSION = "nessie.client-api-version";

    private NessieUtil() {
    }

    static TableIdentifier removeCatalogName(TableIdentifier to, String name) {
        String[] levels = to.namespace().levels();
        if (levels.length >= 2 && name.equalsIgnoreCase(to.namespace().level(0))) {
            Namespace trimmedNamespace = Namespace.of(Arrays.copyOfRange(levels, 1, levels.length));
            return TableIdentifier.of(trimmedNamespace, to.name());
        }
        return to;
    }

    static ContentKey toKey(TableIdentifier tableIdentifier) {
        ArrayList<String> identifiers = Lists.newArrayList();
        if (tableIdentifier.hasNamespace()) {
            identifiers.addAll(Arrays.asList(tableIdentifier.namespace().levels()));
        }
        identifiers.add(tableIdentifier.name());
        return ContentKey.of(identifiers);
    }

    static CommitMeta buildCommitMetadata(String commitMsg, Map<String, String> catalogOptions) {
        return NessieUtil.catalogOptions(CommitMeta.builder().message(commitMsg), catalogOptions).build();
    }

    static ImmutableCommitMeta.Builder catalogOptions(ImmutableCommitMeta.Builder commitMetaBuilder, Map<String, String> catalogOptions) {
        Preconditions.checkArgument(null != catalogOptions, "catalogOptions must not be null");
        commitMetaBuilder.author(NessieUtil.commitAuthor(catalogOptions));
        commitMetaBuilder.putProperties(APPLICATION_TYPE, "iceberg");
        if (catalogOptions.containsKey("app-id")) {
            commitMetaBuilder.putProperties("app-id", catalogOptions.get("app-id"));
        }
        return commitMetaBuilder;
    }

    @Nullable
    private static String commitAuthor(Map<String, String> catalogOptions) {
        return Optional.ofNullable(catalogOptions.get("user")).orElseGet(() -> System.getProperty("user.name"));
    }

    private static void checkAndUpdateGCProperties(TableMetadata tableMetadata, Map<String, String> updatedProperties, String identifier) {
        if (tableMetadata.propertyAsBoolean("nessie.gc.no-warning", false)) {
            return;
        }
        if (tableMetadata.propertyAsBoolean("gc.enabled", true) || tableMetadata.propertyAsBoolean("write.metadata.delete-after-commit.enabled", false)) {
            updatedProperties.put("nessie.gc.no-warning", "true");
            LOG.warn("The Iceberg property '{}' and/or '{}' is enabled on table '{}' in NessieCatalog. This will likely make data in other Nessie branches and tags and in earlier, historical Nessie commits inaccessible. The recommended setting for those properties is 'false'. Use the 'nessie-gc' tool for Nessie reference-aware garbage collection.", new Object[]{"gc.enabled", "write.metadata.delete-after-commit.enabled", identifier});
        }
    }

    public static TableMetadata updateTableMetadataWithNessieSpecificProperties(TableMetadata tableMetadata, String metadataLocation, IcebergTable table, String identifier, Reference reference) {
        HashMap<String, String> newProperties = Maps.newHashMap(tableMetadata.properties());
        newProperties.put("nessie.commit.id", reference.getHash());
        NessieUtil.checkAndUpdateGCProperties(tableMetadata, newProperties, identifier);
        TableMetadata.Builder builder = TableMetadata.buildFrom(tableMetadata).setPreviousFileLocation(null).setCurrentSchema(table.getSchemaId()).setDefaultSortOrder(table.getSortOrderId()).setDefaultPartitionSpec(table.getSpecId()).withMetadataLocation(metadataLocation).setProperties(newProperties);
        if (table.getSnapshotId() != -1L) {
            builder.setBranchSnapshot(table.getSnapshotId(), "main");
        }
        LOG.info("loadTableMetadata for '{}' from location '{}' at '{}'", new Object[]{identifier, metadataLocation, reference});
        return builder.discardChanges().build();
    }
}

