/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.OAuth2ClientParams;
import org.projectnessie.client.http.HttpClient;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OAuth2ClientParams", generator="Immutables")
@Immutable
final class ImmutableOAuth2ClientParams
implements OAuth2ClientParams {
    private final URI tokenEndpoint;
    private final String clientId;
    private final String clientSecret;
    @Nullable
    private final String username;
    @Nullable
    private final String password;
    @Nullable
    private final String scope;
    private final String grantType;
    private final ObjectMapper objectMapper;
    private final Duration defaultAccessTokenLifespan;
    private final Duration defaultRefreshTokenLifespan;
    private final Duration refreshSafetyWindow;
    private final boolean tokenExchangeEnabled;
    @Nullable
    private final ScheduledExecutorService executor;
    private final HttpClient.Builder httpClient;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableOAuth2ClientParams(Builder builder) {
        this.tokenEndpoint = builder.tokenEndpoint;
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.username = builder.username;
        this.password = builder.password;
        this.scope = builder.scope;
        this.executor = builder.executor;
        if (builder.grantType != null) {
            this.initShim.grantType(builder.grantType);
        }
        if (builder.objectMapper != null) {
            this.initShim.objectMapper(builder.objectMapper);
        }
        if (builder.defaultAccessTokenLifespan != null) {
            this.initShim.defaultAccessTokenLifespan(builder.defaultAccessTokenLifespan);
        }
        if (builder.defaultRefreshTokenLifespan != null) {
            this.initShim.defaultRefreshTokenLifespan(builder.defaultRefreshTokenLifespan);
        }
        if (builder.refreshSafetyWindow != null) {
            this.initShim.refreshSafetyWindow(builder.refreshSafetyWindow);
        }
        if (builder.tokenExchangeEnabledIsSet()) {
            this.initShim.tokenExchangeEnabled(builder.tokenExchangeEnabled);
        }
        if (builder.httpClient != null) {
            this.initShim.httpClient(builder.httpClient);
        }
        this.grantType = this.initShim.getGrantType();
        this.objectMapper = this.initShim.getObjectMapper();
        this.defaultAccessTokenLifespan = this.initShim.getDefaultAccessTokenLifespan();
        this.defaultRefreshTokenLifespan = this.initShim.getDefaultRefreshTokenLifespan();
        this.refreshSafetyWindow = this.initShim.getRefreshSafetyWindow();
        this.tokenExchangeEnabled = this.initShim.getTokenExchangeEnabled();
        this.httpClient = this.initShim.getHttpClient();
        this.initShim = null;
    }

    private ImmutableOAuth2ClientParams(URI tokenEndpoint, String clientId, String clientSecret, @Nullable String username, @Nullable String password, @Nullable String scope, String grantType, ObjectMapper objectMapper, Duration defaultAccessTokenLifespan, Duration defaultRefreshTokenLifespan, Duration refreshSafetyWindow, boolean tokenExchangeEnabled, @Nullable ScheduledExecutorService executor, HttpClient.Builder httpClient) {
        this.tokenEndpoint = tokenEndpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.username = username;
        this.password = password;
        this.scope = scope;
        this.grantType = grantType;
        this.objectMapper = objectMapper;
        this.defaultAccessTokenLifespan = defaultAccessTokenLifespan;
        this.defaultRefreshTokenLifespan = defaultRefreshTokenLifespan;
        this.refreshSafetyWindow = refreshSafetyWindow;
        this.tokenExchangeEnabled = tokenExchangeEnabled;
        this.executor = executor;
        this.httpClient = httpClient;
        this.initShim = null;
    }

    private String getGrantTypeInitialize() {
        return OAuth2ClientParams.super.getGrantType();
    }

    private ObjectMapper getObjectMapperInitialize() {
        return OAuth2ClientParams.super.getObjectMapper();
    }

    private Duration getDefaultAccessTokenLifespanInitialize() {
        return OAuth2ClientParams.super.getDefaultAccessTokenLifespan();
    }

    private Duration getDefaultRefreshTokenLifespanInitialize() {
        return OAuth2ClientParams.super.getDefaultRefreshTokenLifespan();
    }

    private Duration getRefreshSafetyWindowInitialize() {
        return OAuth2ClientParams.super.getRefreshSafetyWindow();
    }

    private boolean getTokenExchangeEnabledInitialize() {
        return OAuth2ClientParams.super.getTokenExchangeEnabled();
    }

    private HttpClient.Builder getHttpClientInitialize() {
        return OAuth2ClientParams.super.getHttpClient();
    }

    @Override
    public URI getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Override
    public Optional<String> getPassword() {
        return Optional.ofNullable(this.password);
    }

    @Override
    public Optional<String> getScope() {
        return Optional.ofNullable(this.scope);
    }

    @Override
    public String getGrantType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getGrantType() : this.grantType;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getObjectMapper() : this.objectMapper;
    }

    @Override
    public Duration getDefaultAccessTokenLifespan() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDefaultAccessTokenLifespan() : this.defaultAccessTokenLifespan;
    }

    @Override
    public Duration getDefaultRefreshTokenLifespan() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDefaultRefreshTokenLifespan() : this.defaultRefreshTokenLifespan;
    }

    @Override
    public Duration getRefreshSafetyWindow() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRefreshSafetyWindow() : this.refreshSafetyWindow;
    }

    @Override
    public boolean getTokenExchangeEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getTokenExchangeEnabled() : this.tokenExchangeEnabled;
    }

    @Override
    public Optional<ScheduledExecutorService> getExecutor() {
        return Optional.ofNullable(this.executor);
    }

    @Override
    public HttpClient.Builder getHttpClient() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getHttpClient() : this.httpClient;
    }

    public final ImmutableOAuth2ClientParams withTokenEndpoint(URI value) {
        if (this.tokenEndpoint == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "tokenEndpoint");
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(newValue, this.clientId, this.clientSecret, this.username, this.password, this.scope, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (this.clientId.equals(newValue)) {
            return this;
        }
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, newValue, this.clientSecret, this.username, this.password, this.scope, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withClientSecret(String value) {
        String newValue = Objects.requireNonNull(value, "clientSecret");
        if (this.clientSecret.equals(newValue)) {
            return this;
        }
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, newValue, this.username, this.password, this.scope, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (Objects.equals(this.username, newValue)) {
            return this;
        }
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, newValue, this.password, this.scope, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withUsername(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, value, this.password, this.scope, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (Objects.equals(this.password, newValue)) {
            return this;
        }
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, this.username, newValue, this.scope, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withPassword(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.password, value)) {
            return this;
        }
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, this.username, value, this.scope, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withScope(String value) {
        String newValue = Objects.requireNonNull(value, "scope");
        if (Objects.equals(this.scope, newValue)) {
            return this;
        }
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, this.username, this.password, newValue, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withScope(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, this.username, this.password, value, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withGrantType(String value) {
        String newValue = Objects.requireNonNull(value, "grantType");
        if (this.grantType.equals(newValue)) {
            return this;
        }
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, this.username, this.password, this.scope, newValue, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withObjectMapper(ObjectMapper value) {
        if (this.objectMapper == value) {
            return this;
        }
        ObjectMapper newValue = Objects.requireNonNull(value, "objectMapper");
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, this.username, this.password, this.scope, this.grantType, newValue, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withDefaultAccessTokenLifespan(Duration value) {
        if (this.defaultAccessTokenLifespan == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "defaultAccessTokenLifespan");
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, this.username, this.password, this.scope, this.grantType, this.objectMapper, newValue, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withDefaultRefreshTokenLifespan(Duration value) {
        if (this.defaultRefreshTokenLifespan == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "defaultRefreshTokenLifespan");
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, this.username, this.password, this.scope, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, newValue, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withRefreshSafetyWindow(Duration value) {
        if (this.refreshSafetyWindow == value) {
            return this;
        }
        Duration newValue = Objects.requireNonNull(value, "refreshSafetyWindow");
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, this.username, this.password, this.scope, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, newValue, this.tokenExchangeEnabled, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withTokenExchangeEnabled(boolean value) {
        if (this.tokenExchangeEnabled == value) {
            return this;
        }
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, this.username, this.password, this.scope, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, value, this.executor, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withExecutor(ScheduledExecutorService value) {
        ScheduledExecutorService newValue = Objects.requireNonNull(value, "executor");
        if (this.executor == newValue) {
            return this;
        }
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, this.username, this.password, this.scope, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, newValue, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withExecutor(Optional<? extends ScheduledExecutorService> optional) {
        ScheduledExecutorService value = optional.orElse(null);
        if (this.executor == value) {
            return this;
        }
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, this.username, this.password, this.scope, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, value, this.httpClient));
    }

    public final ImmutableOAuth2ClientParams withHttpClient(HttpClient.Builder value) {
        if (this.httpClient == value) {
            return this;
        }
        HttpClient.Builder newValue = Objects.requireNonNull(value, "httpClient");
        return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this.tokenEndpoint, this.clientId, this.clientSecret, this.username, this.password, this.scope, this.grantType, this.objectMapper, this.defaultAccessTokenLifespan, this.defaultRefreshTokenLifespan, this.refreshSafetyWindow, this.tokenExchangeEnabled, this.executor, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOAuth2ClientParams && this.equalTo(0, (ImmutableOAuth2ClientParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableOAuth2ClientParams another) {
        return this.tokenEndpoint.equals(another.tokenEndpoint) && this.clientId.equals(another.clientId) && this.clientSecret.equals(another.clientSecret) && Objects.equals(this.username, another.username) && Objects.equals(this.password, another.password) && Objects.equals(this.scope, another.scope) && this.grantType.equals(another.grantType) && this.objectMapper.equals(another.objectMapper) && this.defaultAccessTokenLifespan.equals(another.defaultAccessTokenLifespan) && this.defaultRefreshTokenLifespan.equals(another.defaultRefreshTokenLifespan) && this.refreshSafetyWindow.equals(another.refreshSafetyWindow) && this.tokenExchangeEnabled == another.tokenExchangeEnabled && Objects.equals(this.executor, another.executor) && this.httpClient.equals(another.httpClient);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.tokenEndpoint.hashCode();
        h2 += (h2 << 5) + this.clientId.hashCode();
        h2 += (h2 << 5) + this.clientSecret.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.username);
        h2 += (h2 << 5) + Objects.hashCode(this.password);
        h2 += (h2 << 5) + Objects.hashCode(this.scope);
        h2 += (h2 << 5) + this.grantType.hashCode();
        h2 += (h2 << 5) + this.objectMapper.hashCode();
        h2 += (h2 << 5) + this.defaultAccessTokenLifespan.hashCode();
        h2 += (h2 << 5) + this.defaultRefreshTokenLifespan.hashCode();
        h2 += (h2 << 5) + this.refreshSafetyWindow.hashCode();
        h2 += (h2 << 5) + Boolean.hashCode(this.tokenExchangeEnabled);
        h2 += (h2 << 5) + Objects.hashCode(this.executor);
        h2 += (h2 << 5) + this.httpClient.hashCode();
        return h2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OAuth2ClientParams{");
        builder.append("tokenEndpoint=").append(this.tokenEndpoint);
        builder.append(", ");
        builder.append("clientId=").append(this.clientId);
        builder.append(", ");
        builder.append("clientSecret=").append(this.clientSecret);
        if (this.username != null) {
            builder.append(", ");
            builder.append("username=").append(this.username);
        }
        if (this.password != null) {
            builder.append(", ");
            builder.append("password=").append(this.password);
        }
        if (this.scope != null) {
            builder.append(", ");
            builder.append("scope=").append(this.scope);
        }
        builder.append(", ");
        builder.append("grantType=").append(this.grantType);
        builder.append(", ");
        builder.append("objectMapper=").append(this.objectMapper);
        builder.append(", ");
        builder.append("defaultAccessTokenLifespan=").append(this.defaultAccessTokenLifespan);
        builder.append(", ");
        builder.append("defaultRefreshTokenLifespan=").append(this.defaultRefreshTokenLifespan);
        builder.append(", ");
        builder.append("refreshSafetyWindow=").append(this.refreshSafetyWindow);
        builder.append(", ");
        builder.append("tokenExchangeEnabled=").append(this.tokenExchangeEnabled);
        if (this.executor != null) {
            builder.append(", ");
            builder.append("executor=").append(this.executor);
        }
        builder.append(", ");
        builder.append("httpClient=").append(this.httpClient);
        return builder.append("}").toString();
    }

    private static ImmutableOAuth2ClientParams validate(ImmutableOAuth2ClientParams instance) {
        instance.check();
        return instance;
    }

    public static ImmutableOAuth2ClientParams copyOf(OAuth2ClientParams instance) {
        if (instance instanceof ImmutableOAuth2ClientParams) {
            return (ImmutableOAuth2ClientParams)instance;
        }
        return ImmutableOAuth2ClientParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OAuth2ClientParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN_ENDPOINT = 1L;
        private static final long INIT_BIT_CLIENT_ID = 2L;
        private static final long INIT_BIT_CLIENT_SECRET = 4L;
        private static final long OPT_BIT_TOKEN_EXCHANGE_ENABLED = 1L;
        private long initBits = 7L;
        private long optBits;
        @Nullable
        private URI tokenEndpoint;
        @Nullable
        private String clientId;
        @Nullable
        private String clientSecret;
        @Nullable
        private String username;
        @Nullable
        private String password;
        @Nullable
        private String scope;
        @Nullable
        private String grantType;
        @Nullable
        private ObjectMapper objectMapper;
        @Nullable
        private Duration defaultAccessTokenLifespan;
        @Nullable
        private Duration defaultRefreshTokenLifespan;
        @Nullable
        private Duration refreshSafetyWindow;
        private boolean tokenExchangeEnabled;
        @Nullable
        private ScheduledExecutorService executor;
        @Nullable
        private HttpClient.Builder httpClient;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OAuth2ClientParams instance) {
            Optional<String> scopeOptional;
            Optional<String> passwordOptional;
            Objects.requireNonNull(instance, "instance");
            this.tokenEndpoint(instance.getTokenEndpoint());
            this.clientId(instance.getClientId());
            this.clientSecret(instance.getClientSecret());
            Optional<String> usernameOptional = instance.getUsername();
            if (usernameOptional.isPresent()) {
                this.username(usernameOptional);
            }
            if ((passwordOptional = instance.getPassword()).isPresent()) {
                this.password(passwordOptional);
            }
            if ((scopeOptional = instance.getScope()).isPresent()) {
                this.scope(scopeOptional);
            }
            this.grantType(instance.getGrantType());
            this.objectMapper(instance.getObjectMapper());
            this.defaultAccessTokenLifespan(instance.getDefaultAccessTokenLifespan());
            this.defaultRefreshTokenLifespan(instance.getDefaultRefreshTokenLifespan());
            this.refreshSafetyWindow(instance.getRefreshSafetyWindow());
            this.tokenExchangeEnabled(instance.getTokenExchangeEnabled());
            Optional<ScheduledExecutorService> executorOptional = instance.getExecutor();
            if (executorOptional.isPresent()) {
                this.executor(executorOptional);
            }
            this.httpClient(instance.getHttpClient());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tokenEndpoint(URI tokenEndpoint) {
            this.tokenEndpoint = Objects.requireNonNull(tokenEndpoint, "tokenEndpoint");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder username(Optional<String> username) {
            this.username = username.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder password(Optional<String> password) {
            this.password = password.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scope(String scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scope(Optional<String> scope) {
            this.scope = scope.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder grantType(String grantType) {
            this.grantType = Objects.requireNonNull(grantType, "grantType");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultAccessTokenLifespan(Duration defaultAccessTokenLifespan) {
            this.defaultAccessTokenLifespan = Objects.requireNonNull(defaultAccessTokenLifespan, "defaultAccessTokenLifespan");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultRefreshTokenLifespan(Duration defaultRefreshTokenLifespan) {
            this.defaultRefreshTokenLifespan = Objects.requireNonNull(defaultRefreshTokenLifespan, "defaultRefreshTokenLifespan");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder refreshSafetyWindow(Duration refreshSafetyWindow) {
            this.refreshSafetyWindow = Objects.requireNonNull(refreshSafetyWindow, "refreshSafetyWindow");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tokenExchangeEnabled(boolean tokenExchangeEnabled) {
            this.tokenExchangeEnabled = tokenExchangeEnabled;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder executor(ScheduledExecutorService executor) {
            this.executor = Objects.requireNonNull(executor, "executor");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder executor(Optional<? extends ScheduledExecutorService> executor) {
            this.executor = executor.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder httpClient(HttpClient.Builder httpClient) {
            this.httpClient = Objects.requireNonNull(httpClient, "httpClient");
            return this;
        }

        public ImmutableOAuth2ClientParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableOAuth2ClientParams.validate(new ImmutableOAuth2ClientParams(this));
        }

        private boolean tokenExchangeEnabledIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tokenEndpoint");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("clientSecret");
            }
            return "Cannot build OAuth2ClientParams, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="OAuth2ClientParams", generator="Immutables")
    private final class InitShim {
        private byte grantTypeBuildStage = 0;
        private String grantType;
        private byte objectMapperBuildStage = 0;
        private ObjectMapper objectMapper;
        private byte defaultAccessTokenLifespanBuildStage = 0;
        private Duration defaultAccessTokenLifespan;
        private byte defaultRefreshTokenLifespanBuildStage = 0;
        private Duration defaultRefreshTokenLifespan;
        private byte refreshSafetyWindowBuildStage = 0;
        private Duration refreshSafetyWindow;
        private byte tokenExchangeEnabledBuildStage = 0;
        private boolean tokenExchangeEnabled;
        private byte httpClientBuildStage = 0;
        private HttpClient.Builder httpClient;

        private InitShim() {
        }

        String getGrantType() {
            if (this.grantTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.grantTypeBuildStage == 0) {
                this.grantTypeBuildStage = (byte)-1;
                this.grantType = Objects.requireNonNull(ImmutableOAuth2ClientParams.this.getGrantTypeInitialize(), "grantType");
                this.grantTypeBuildStage = 1;
            }
            return this.grantType;
        }

        void grantType(String grantType) {
            this.grantType = grantType;
            this.grantTypeBuildStage = 1;
        }

        ObjectMapper getObjectMapper() {
            if (this.objectMapperBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectMapperBuildStage == 0) {
                this.objectMapperBuildStage = (byte)-1;
                this.objectMapper = Objects.requireNonNull(ImmutableOAuth2ClientParams.this.getObjectMapperInitialize(), "objectMapper");
                this.objectMapperBuildStage = 1;
            }
            return this.objectMapper;
        }

        void objectMapper(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
            this.objectMapperBuildStage = 1;
        }

        Duration getDefaultAccessTokenLifespan() {
            if (this.defaultAccessTokenLifespanBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultAccessTokenLifespanBuildStage == 0) {
                this.defaultAccessTokenLifespanBuildStage = (byte)-1;
                this.defaultAccessTokenLifespan = Objects.requireNonNull(ImmutableOAuth2ClientParams.this.getDefaultAccessTokenLifespanInitialize(), "defaultAccessTokenLifespan");
                this.defaultAccessTokenLifespanBuildStage = 1;
            }
            return this.defaultAccessTokenLifespan;
        }

        void defaultAccessTokenLifespan(Duration defaultAccessTokenLifespan) {
            this.defaultAccessTokenLifespan = defaultAccessTokenLifespan;
            this.defaultAccessTokenLifespanBuildStage = 1;
        }

        Duration getDefaultRefreshTokenLifespan() {
            if (this.defaultRefreshTokenLifespanBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultRefreshTokenLifespanBuildStage == 0) {
                this.defaultRefreshTokenLifespanBuildStage = (byte)-1;
                this.defaultRefreshTokenLifespan = Objects.requireNonNull(ImmutableOAuth2ClientParams.this.getDefaultRefreshTokenLifespanInitialize(), "defaultRefreshTokenLifespan");
                this.defaultRefreshTokenLifespanBuildStage = 1;
            }
            return this.defaultRefreshTokenLifespan;
        }

        void defaultRefreshTokenLifespan(Duration defaultRefreshTokenLifespan) {
            this.defaultRefreshTokenLifespan = defaultRefreshTokenLifespan;
            this.defaultRefreshTokenLifespanBuildStage = 1;
        }

        Duration getRefreshSafetyWindow() {
            if (this.refreshSafetyWindowBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.refreshSafetyWindowBuildStage == 0) {
                this.refreshSafetyWindowBuildStage = (byte)-1;
                this.refreshSafetyWindow = Objects.requireNonNull(ImmutableOAuth2ClientParams.this.getRefreshSafetyWindowInitialize(), "refreshSafetyWindow");
                this.refreshSafetyWindowBuildStage = 1;
            }
            return this.refreshSafetyWindow;
        }

        void refreshSafetyWindow(Duration refreshSafetyWindow) {
            this.refreshSafetyWindow = refreshSafetyWindow;
            this.refreshSafetyWindowBuildStage = 1;
        }

        boolean getTokenExchangeEnabled() {
            if (this.tokenExchangeEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tokenExchangeEnabledBuildStage == 0) {
                this.tokenExchangeEnabledBuildStage = (byte)-1;
                this.tokenExchangeEnabled = ImmutableOAuth2ClientParams.this.getTokenExchangeEnabledInitialize();
                this.tokenExchangeEnabledBuildStage = 1;
            }
            return this.tokenExchangeEnabled;
        }

        void tokenExchangeEnabled(boolean tokenExchangeEnabled) {
            this.tokenExchangeEnabled = tokenExchangeEnabled;
            this.tokenExchangeEnabledBuildStage = 1;
        }

        HttpClient.Builder getHttpClient() {
            if (this.httpClientBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.httpClientBuildStage == 0) {
                this.httpClientBuildStage = (byte)-1;
                this.httpClient = Objects.requireNonNull(ImmutableOAuth2ClientParams.this.getHttpClientInitialize(), "httpClient");
                this.httpClientBuildStage = 1;
            }
            return this.httpClient;
        }

        void httpClient(HttpClient.Builder httpClient) {
            this.httpClient = httpClient;
            this.httpClientBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.grantTypeBuildStage == -1) {
                attributes.add("grantType");
            }
            if (this.objectMapperBuildStage == -1) {
                attributes.add("objectMapper");
            }
            if (this.defaultAccessTokenLifespanBuildStage == -1) {
                attributes.add("defaultAccessTokenLifespan");
            }
            if (this.defaultRefreshTokenLifespanBuildStage == -1) {
                attributes.add("defaultRefreshTokenLifespan");
            }
            if (this.refreshSafetyWindowBuildStage == -1) {
                attributes.add("refreshSafetyWindow");
            }
            if (this.tokenExchangeEnabledBuildStage == -1) {
                attributes.add("tokenExchangeEnabled");
            }
            if (this.httpClientBuildStage == -1) {
                attributes.add("httpClient");
            }
            return "Cannot build OAuth2ClientParams, attribute initializers form cycle " + attributes;
        }
    }
}

