/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.NessieApiCompatibilityException;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.RequestFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NessieApiCompatibilityFilter
implements RequestFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NessieApiCompatibilityFilter.class);
    private static final String MIN_API_VERSION = "minSupportedApiVersion";
    private static final String MAX_API_VERSION = "maxSupportedApiVersion";
    private static final String ACTUAL_API_VERSION = "actualApiVersion";
    private HttpClient.Builder builder;
    private final int clientApiVersion;
    private final AtomicBoolean checkDone = new AtomicBoolean(false);

    NessieApiCompatibilityFilter(HttpClient.Builder builder, int clientApiVersion) {
        this.builder = builder.copy().clearRequestFilters().clearResponseFilters();
        this.clientApiVersion = clientApiVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void filter(RequestContext context) {
        if (this.checkDone.compareAndSet(false, true)) {
            try (HttpClient httpClient = this.builder.build();){
                NessieApiCompatibilityFilter.check(this.clientApiVersion, httpClient);
            }
            finally {
                this.builder = null;
            }
        }
    }

    static void check(int clientApiVersion, HttpClient httpClient) throws NessieApiCompatibilityException {
        int actualServerApiVersion;
        JsonNode config;
        try {
            config = httpClient.newRequest().path("config").get().readEntity(JsonNode.class);
        }
        catch (Exception e) {
            LOGGER.warn("API compatibility check: failed to contact config endpoint, proceeding without check", (Throwable)e);
            return;
        }
        int minServerApiVersion = config.hasNonNull(MIN_API_VERSION) ? config.get(MIN_API_VERSION).asInt() : 1;
        int maxServerApiVersion = config.get(MAX_API_VERSION).asInt();
        int n = actualServerApiVersion = config.hasNonNull(ACTUAL_API_VERSION) ? config.get(ACTUAL_API_VERSION).asInt() : 1;
        if (clientApiVersion < minServerApiVersion || clientApiVersion > maxServerApiVersion || clientApiVersion != actualServerApiVersion) {
            throw new NessieApiCompatibilityException(clientApiVersion, minServerApiVersion, maxServerApiVersion, actualServerApiVersion);
        }
    }
}

