/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.BaseFilesTable;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.io.CloseableIterable;

public class DeleteFilesTable
extends BaseFilesTable {
    DeleteFilesTable(Table table) {
        this(table, table.name() + ".delete_files");
    }

    DeleteFilesTable(Table table, String name) {
        super(table, name);
    }

    @Override
    public TableScan newScan() {
        return new DeleteFilesTableScan(this.table(), this.schema());
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.DELETE_FILES;
    }

    public static class DeleteFilesTableScan
    extends BaseFilesTable.BaseFilesTableScan {
        DeleteFilesTableScan(Table table, Schema schema) {
            super(table, schema, MetadataTableType.DELETE_FILES);
        }

        DeleteFilesTableScan(Table table, Schema schema, TableScanContext context) {
            super(table, schema, MetadataTableType.DELETE_FILES, context);
        }

        @Override
        protected TableScan newRefinedScan(Table table, Schema schema, TableScanContext context) {
            return new DeleteFilesTableScan(table, schema, context);
        }

        @Override
        protected CloseableIterable<ManifestFile> manifests() {
            return CloseableIterable.withNoopClose(this.snapshot().deleteManifests(this.table().io()));
        }
    }
}

