/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3.signer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.aws.s3.signer.S3V4RestSignerClient;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="S3V4RestSignerClient", generator="Immutables")
@Immutable
public final class ImmutableS3V4RestSignerClient
extends S3V4RestSignerClient {
    private final Map<String, String> properties;
    private final Supplier<Map<String, String>> requestPropertiesSupplier;
    private final Supplier<String> token;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private volatile transient long lazyInitBitmap;
    private static final long BASE_SIGNER_URI_LAZY_INIT_BIT = 1L;
    private transient String baseSignerUri;
    private static final long ENDPOINT_LAZY_INIT_BIT = 2L;
    private transient String endpoint;
    private static final long CREDENTIAL_LAZY_INIT_BIT = 4L;
    private transient String credential;
    private static final long OAUTH2_SERVER_URI_LAZY_INIT_BIT = 8L;
    private transient String oauth2ServerUri;
    private static final long KEEP_TOKEN_REFRESHED_LAZY_INIT_BIT = 16L;
    private transient boolean keepTokenRefreshed;

    private ImmutableS3V4RestSignerClient(Builder builder) {
        this.properties = ImmutableS3V4RestSignerClient.createUnmodifiableMap(false, false, builder.properties);
        if (builder.requestPropertiesSupplier != null) {
            this.initShim.requestPropertiesSupplier(builder.requestPropertiesSupplier);
        }
        if (builder.token != null) {
            this.initShim.token(builder.token);
        }
        this.requestPropertiesSupplier = this.initShim.requestPropertiesSupplier();
        this.token = this.initShim.token();
        this.initShim = null;
    }

    private ImmutableS3V4RestSignerClient(Map<String, String> properties, Supplier<Map<String, String>> requestPropertiesSupplier, Supplier<String> token) {
        this.properties = properties;
        this.requestPropertiesSupplier = requestPropertiesSupplier;
        this.token = token;
        this.initShim = null;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    @Override
    public Supplier<Map<String, String>> requestPropertiesSupplier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.requestPropertiesSupplier() : this.requestPropertiesSupplier;
    }

    @Override
    public Supplier<String> token() {
        InitShim shim = this.initShim;
        return shim != null ? shim.token() : this.token;
    }

    public final ImmutableS3V4RestSignerClient withProperties(Map<String, ? extends String> entries) {
        if (this.properties == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableS3V4RestSignerClient.createUnmodifiableMap(true, false, entries);
        return ImmutableS3V4RestSignerClient.validate(new ImmutableS3V4RestSignerClient(newValue, this.requestPropertiesSupplier, this.token));
    }

    public final ImmutableS3V4RestSignerClient withRequestPropertiesSupplier(Supplier<Map<String, String>> value) {
        if (this.requestPropertiesSupplier == value) {
            return this;
        }
        Supplier<Map<String, String>> newValue = Objects.requireNonNull(value, "requestPropertiesSupplier");
        return ImmutableS3V4RestSignerClient.validate(new ImmutableS3V4RestSignerClient(this.properties, newValue, this.token));
    }

    public final ImmutableS3V4RestSignerClient withToken(Supplier<String> value) {
        if (this.token == value) {
            return this;
        }
        Supplier<String> newValue = Objects.requireNonNull(value, "token");
        return ImmutableS3V4RestSignerClient.validate(new ImmutableS3V4RestSignerClient(this.properties, this.requestPropertiesSupplier, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableS3V4RestSignerClient && this.equalTo(0, (ImmutableS3V4RestSignerClient)((Object)another));
    }

    private boolean equalTo(int synthetic, ImmutableS3V4RestSignerClient another) {
        return this.properties.equals(another.properties) && this.requestPropertiesSupplier.equals(another.requestPropertiesSupplier) && this.token.equals(another.token);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.properties.hashCode();
        h2 += (h2 << 5) + this.requestPropertiesSupplier.hashCode();
        h2 += (h2 << 5) + this.token.hashCode();
        return h2;
    }

    public String toString() {
        return "S3V4RestSignerClient{properties=" + this.properties + ", requestPropertiesSupplier=" + this.requestPropertiesSupplier + ", token=" + this.token + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String baseSignerUri() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableS3V4RestSignerClient immutableS3V4RestSignerClient = this;
            synchronized (immutableS3V4RestSignerClient) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.baseSignerUri = Objects.requireNonNull(super.baseSignerUri(), "baseSignerUri");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.baseSignerUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String endpoint() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableS3V4RestSignerClient immutableS3V4RestSignerClient = this;
            synchronized (immutableS3V4RestSignerClient) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.endpoint = Objects.requireNonNull(super.endpoint(), "endpoint");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.endpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String credential() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableS3V4RestSignerClient immutableS3V4RestSignerClient = this;
            synchronized (immutableS3V4RestSignerClient) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.credential = super.credential();
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.credential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String oauth2ServerUri() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            ImmutableS3V4RestSignerClient immutableS3V4RestSignerClient = this;
            synchronized (immutableS3V4RestSignerClient) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.oauth2ServerUri = Objects.requireNonNull(super.oauth2ServerUri(), "oauth2ServerUri");
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.oauth2ServerUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean keepTokenRefreshed() {
        if ((this.lazyInitBitmap & 0x10L) == 0L) {
            ImmutableS3V4RestSignerClient immutableS3V4RestSignerClient = this;
            synchronized (immutableS3V4RestSignerClient) {
                if ((this.lazyInitBitmap & 0x10L) == 0L) {
                    this.keepTokenRefreshed = super.keepTokenRefreshed();
                    this.lazyInitBitmap |= 0x10L;
                }
            }
        }
        return this.keepTokenRefreshed;
    }

    private static ImmutableS3V4RestSignerClient validate(ImmutableS3V4RestSignerClient instance) {
        instance.check();
        return instance;
    }

    public static ImmutableS3V4RestSignerClient copyOf(S3V4RestSignerClient instance) {
        if (instance instanceof ImmutableS3V4RestSignerClient) {
            return (ImmutableS3V4RestSignerClient)instance;
        }
        return ImmutableS3V4RestSignerClient.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="S3V4RestSignerClient", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private Map<String, String> properties = new LinkedHashMap<String, String>();
        @Nullable
        private Supplier<Map<String, String>> requestPropertiesSupplier;
        @Nullable
        private Supplier<String> token;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(S3V4RestSignerClient instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllProperties(instance.properties());
            this.requestPropertiesSupplier(instance.requestPropertiesSupplier());
            this.token(instance.token());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(String key, String value) {
            this.properties.put(Objects.requireNonNull(key, "properties key"), Objects.requireNonNull(value, value == null ? "properties value for key: " + key : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "properties value for key: " + k : null));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder properties(Map<String, ? extends String> entries) {
            this.properties.clear();
            return this.putAllProperties(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllProperties(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.properties.put(Objects.requireNonNull(k, "properties key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "properties value for key: " + k : null));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder requestPropertiesSupplier(Supplier<Map<String, String>> requestPropertiesSupplier) {
            this.requestPropertiesSupplier = Objects.requireNonNull(requestPropertiesSupplier, "requestPropertiesSupplier");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(Supplier<String> token) {
            this.token = Objects.requireNonNull(token, "token");
            return this;
        }

        public ImmutableS3V4RestSignerClient build() {
            return ImmutableS3V4RestSignerClient.validate(new ImmutableS3V4RestSignerClient(this));
        }
    }

    @Generated(from="S3V4RestSignerClient", generator="Immutables")
    private final class InitShim {
        private byte requestPropertiesSupplierBuildStage = 0;
        private Supplier<Map<String, String>> requestPropertiesSupplier;
        private byte tokenBuildStage = 0;
        private Supplier<String> token;

        private InitShim() {
        }

        Supplier<Map<String, String>> requestPropertiesSupplier() {
            if (this.requestPropertiesSupplierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestPropertiesSupplierBuildStage == 0) {
                this.requestPropertiesSupplierBuildStage = (byte)-1;
                this.requestPropertiesSupplier = Objects.requireNonNull(ImmutableS3V4RestSignerClient.super.requestPropertiesSupplier(), "requestPropertiesSupplier");
                this.requestPropertiesSupplierBuildStage = 1;
            }
            return this.requestPropertiesSupplier;
        }

        void requestPropertiesSupplier(Supplier<Map<String, String>> requestPropertiesSupplier) {
            this.requestPropertiesSupplier = requestPropertiesSupplier;
            this.requestPropertiesSupplierBuildStage = 1;
        }

        Supplier<String> token() {
            if (this.tokenBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.tokenBuildStage == 0) {
                this.tokenBuildStage = (byte)-1;
                this.token = Objects.requireNonNull(ImmutableS3V4RestSignerClient.super.token(), "token");
                this.tokenBuildStage = 1;
            }
            return this.token;
        }

        void token(Supplier<String> token) {
            this.token = token;
            this.tokenBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.requestPropertiesSupplierBuildStage == -1) {
                attributes.add("requestPropertiesSupplier");
            }
            if (this.tokenBuildStage == -1) {
                attributes.add("token");
            }
            return "Cannot build S3V4RestSignerClient, attribute initializers form cycle " + attributes;
        }
    }
}

