/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.gcs;

import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Storage;
import org.apache.iceberg.gcp.GCPProperties;
import org.apache.iceberg.gcp.gcs.BaseGCSFile;
import org.apache.iceberg.gcp.gcs.GCSInputStream;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.metrics.MetricsContext;

class GCSInputFile
extends BaseGCSFile
implements InputFile {
    private Long blobSize;

    static GCSInputFile fromLocation(String location, Storage storage, GCPProperties gcpProperties, MetricsContext metrics) {
        return new GCSInputFile(storage, BlobId.fromGsUtilUri((String)location), null, gcpProperties, metrics);
    }

    static GCSInputFile fromLocation(String location, long length, Storage storage, GCPProperties gcpProperties, MetricsContext metrics) {
        return new GCSInputFile(storage, BlobId.fromGsUtilUri((String)location), length > 0L ? Long.valueOf(length) : null, gcpProperties, metrics);
    }

    GCSInputFile(Storage storage, BlobId blobId, Long blobSize, GCPProperties gcpProperties, MetricsContext metrics) {
        super(storage, blobId, gcpProperties, metrics);
        this.blobSize = blobSize;
    }

    @Override
    public long getLength() {
        if (this.blobSize == null) {
            this.blobSize = this.getBlob().getSize();
        }
        return this.blobSize;
    }

    @Override
    public SeekableInputStream newStream() {
        return new GCSInputStream(this.storage(), this.blobId(), this.blobSize, this.gcpProperties(), this.metrics());
    }
}

