/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.gcs;

import com.google.cloud.WriteChannel;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Storage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.iceberg.gcp.GCPProperties;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GCSOutputStream
extends PositionOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(GCSOutputStream.class);
    private final StackTraceElement[] createStack;
    private final Storage storage;
    private final BlobId blobId;
    private final GCPProperties gcpProperties;
    private OutputStream stream;
    private final Counter writeBytes;
    private final Counter writeOperations;
    private long pos = 0L;
    private boolean closed = false;

    GCSOutputStream(Storage storage, BlobId blobId, GCPProperties gcpProperties, MetricsContext metrics) throws IOException {
        this.storage = storage;
        this.blobId = blobId;
        this.gcpProperties = gcpProperties;
        this.createStack = Thread.currentThread().getStackTrace();
        this.writeBytes = metrics.counter("write.bytes", MetricsContext.Unit.BYTES);
        this.writeOperations = metrics.counter("write.operations");
        this.openStream();
    }

    @Override
    public long getPos() {
        return this.pos;
    }

    @Override
    public void flush() throws IOException {
        this.stream.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.stream.write(b);
        ++this.pos;
        this.writeBytes.increment();
        this.writeOperations.increment();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.stream.write(b, off, len);
        this.pos += (long)len;
        this.writeBytes.increment(len);
        this.writeOperations.increment();
    }

    private void openStream() {
        ArrayList writeOptions = Lists.newArrayList();
        this.gcpProperties.encryptionKey().ifPresent(key -> writeOptions.add(Storage.BlobWriteOption.encryptionKey((String)key)));
        this.gcpProperties.userProject().ifPresent(userProject -> writeOptions.add(Storage.BlobWriteOption.userProject((String)userProject)));
        WriteChannel channel = this.storage.writer(BlobInfo.newBuilder((BlobId)this.blobId).build(), writeOptions.toArray(new Storage.BlobWriteOption[0]));
        this.gcpProperties.channelWriteChunkSize().ifPresent(arg_0 -> ((WriteChannel)channel).setChunkSize(arg_0));
        this.stream = Channels.newOutputStream((WritableByteChannel)channel);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.closed = true;
        this.stream.close();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            this.close();
            String trace = Joiner.on("\n\t").join(Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
            LOG.warn("Unclosed output stream created by:\n\t{}", (Object)trace);
        }
    }
}

