/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import org.apache.iceberg.rest.RESTSerializers;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.PropertyAccessor;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonFactory;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategy;

class RESTObjectMapper {
    private static final JsonFactory FACTORY = new JsonFactory();
    private static final ObjectMapper MAPPER = new ObjectMapper(FACTORY);
    private static volatile boolean isInitialized = false;

    private RESTObjectMapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ObjectMapper mapper() {
        if (isInitialized) return MAPPER;
        Class<RESTObjectMapper> clazz = RESTObjectMapper.class;
        synchronized (RESTObjectMapper.class) {
            if (isInitialized) return MAPPER;
            MAPPER.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            MAPPER.setPropertyNamingStrategy(new PropertyNamingStrategy.KebabCaseStrategy());
            RESTSerializers.registerAll(MAPPER);
            isInitialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return MAPPER;
        }
    }
}

