/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.io.airlift.compress.snappy;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.iceberg.shaded.io.airlift.compress.hadoop.HadoopInputStream;
import org.apache.iceberg.shaded.io.airlift.compress.hadoop.HadoopOutputStream;
import org.apache.iceberg.shaded.io.airlift.compress.hadoop.HadoopStreams;
import org.apache.iceberg.shaded.io.airlift.compress.snappy.SnappyHadoopInputStream;
import org.apache.iceberg.shaded.io.airlift.compress.snappy.SnappyHadoopOutputStream;

public class SnappyHadoopStreams
implements HadoopStreams {
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 262144;
    private final int bufferSize;

    public SnappyHadoopStreams() {
        this(262144);
    }

    public SnappyHadoopStreams(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public String getDefaultFileExtension() {
        return ".snappy";
    }

    @Override
    public List<String> getHadoopCodecName() {
        return Collections.singletonList("org.apache.hadoop.io.compress.SnappyCodec");
    }

    @Override
    public HadoopInputStream createInputStream(InputStream in) {
        return new SnappyHadoopInputStream(in);
    }

    @Override
    public HadoopOutputStream createOutputStream(OutputStream out) {
        return new SnappyHadoopOutputStream(out, this.bufferSize);
    }
}

