/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.api.ns;

import java.util.Objects;
import java.util.Optional;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetMultipleNamespacesBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.builder.BaseGetMultipleNamespacesBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.GetNamespacesResponse;
import org.projectnessie.model.ImmutableGetNamespacesResponse;
import org.projectnessie.model.Namespace;

public final class ClientSideGetMultipleNamespaces
extends BaseGetMultipleNamespacesBuilder {
    private final NessieApiV2 api;
    private boolean onlyDirectChildren;

    public ClientSideGetMultipleNamespaces(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public GetMultipleNamespacesBuilder onlyDirectChildren(boolean onlyDirectChildren) {
        this.onlyDirectChildren = onlyDirectChildren;
        return this;
    }

    @Override
    public GetNamespacesResponse get() throws NessieReferenceNotFoundException {
        ImmutableGetNamespacesResponse.Builder builder = GetNamespacesResponse.builder();
        try {
            EntriesResponse response;
            GetEntriesBuilder getEntries = ((GetEntriesBuilder)((GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().maxRecords(100)).refName(this.refName)).hashOnRef(this.hashOnRef)).withContent(true);
            String filter = "entry.contentType == 'NAMESPACE'";
            if (this.namespace != null && !this.namespace.isEmpty()) {
                String nsName = this.namespace.name();
                filter = filter + (this.onlyDirectChildren ? String.format(" && size(entry.keyElements) == %d && entry.encodedKey.startsWith('%s.')", this.namespace.getElementCount() + 1, nsName) : String.format("&& (entry.encodedKey == '%s' || entry.encodedKey.startsWith('%s.'))", nsName, nsName));
            } else if (this.onlyDirectChildren) {
                filter = filter + " && size(entry.keyElements) == 1";
            }
            getEntries.filter(filter);
            do {
                response = getEntries.get();
                builder.effectiveReference(response.getEffectiveReference());
                response.getEntries().stream().map(EntriesResponse.Entry::getContent).filter(Objects::nonNull).map(v -> v.unwrap(Namespace.class)).filter(Optional::isPresent).map(Optional::get).forEach(builder::addNamespaces);
                getEntries = (GetEntriesBuilder)getEntries.pageToken(response.getToken());
            } while (response.isHasMore());
        }
        catch (NessieNotFoundException e) {
            throw new NessieReferenceNotFoundException(e.getMessage(), e);
        }
        return builder.build();
    }
}

