/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Generated;
import org.projectnessie.model.Branch;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferenceMetadata;

@ParametersAreNonnullByDefault
@Generated(from="Branch", generator="Immutables")
@Immutable
public final class ImmutableBranch
implements Branch {
    private final String name;
    private final ReferenceMetadata metadata;
    private final String hash;

    private ImmutableBranch(String name, String hash, ReferenceMetadata metadata) {
        this.name = Objects.requireNonNull(name, "name");
        this.hash = hash;
        this.metadata = metadata;
    }

    private ImmutableBranch(ImmutableBranch original, String name, ReferenceMetadata metadata, String hash) {
        this.name = name;
        this.metadata = metadata;
        this.hash = hash;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="metadata")
    public ReferenceMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="hash")
    public String getHash() {
        return this.hash;
    }

    public final ImmutableBranch withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableBranch.validate(new ImmutableBranch(this, newValue, this.metadata, this.hash));
    }

    public final ImmutableBranch withMetadata(ReferenceMetadata value) {
        if (this.metadata == value) {
            return this;
        }
        return ImmutableBranch.validate(new ImmutableBranch(this, this.name, value, this.hash));
    }

    public final ImmutableBranch withHash(String value) {
        if (Objects.equals(this.hash, value)) {
            return this;
        }
        return ImmutableBranch.validate(new ImmutableBranch(this, this.name, this.metadata, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBranch && this.equalTo(0, (ImmutableBranch)another);
    }

    private boolean equalTo(int synthetic, ImmutableBranch another) {
        return this.name.equals(another.name) && Objects.equals(this.metadata, another.metadata) && Objects.equals(this.hash, another.hash);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.metadata);
        h2 += (h2 << 5) + Objects.hashCode(this.hash);
        return h2;
    }

    public String toString() {
        return "Branch{name=" + this.name + ", metadata=" + this.metadata + ", hash=" + this.hash + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBranch fromJson(Json json) {
        Builder builder = ImmutableBranch.builder();
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        return builder.build();
    }

    public static ImmutableBranch of(String name, String hash, ReferenceMetadata metadata) {
        return ImmutableBranch.validate(new ImmutableBranch(name, hash, metadata));
    }

    private static ImmutableBranch validate(ImmutableBranch instance) {
        instance.checkName();
        instance.checkHash();
        return instance;
    }

    public static ImmutableBranch copyOf(Branch instance) {
        if (instance instanceof ImmutableBranch) {
            return (ImmutableBranch)instance;
        }
        return ImmutableBranch.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Branch", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        @Nullable
        private ReferenceMetadata metadata;
        @Nullable
        private String hash;

        private Builder() {
        }

        public final Builder from(Branch instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Reference instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String hashValue;
            ReferenceMetadata metadataValue;
            Reference instance;
            long bits = 0L;
            if (object instanceof Branch) {
                instance = (Branch)object;
                if ((bits & 2L) == 0L) {
                    this.name(instance.getName());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    metadataValue = instance.getMetadata();
                    if (metadataValue != null) {
                        this.metadata(metadataValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    hashValue = instance.getHash();
                    if (hashValue != null) {
                        this.hash(hashValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof Reference) {
                instance = (Reference)object;
                if ((bits & 2L) == 0L) {
                    this.name(instance.getName());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    metadataValue = instance.getMetadata();
                    if (metadataValue != null) {
                        this.metadata(metadataValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    hashValue = instance.getHash();
                    if (hashValue != null) {
                        this.hash(hashValue);
                    }
                    bits |= 4L;
                }
            }
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="metadata")
        public final Builder metadata(ReferenceMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @JsonProperty(value="hash")
        public final Builder hash(String hash) {
            this.hash = hash;
            return this;
        }

        public ImmutableBranch build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableBranch.validate(new ImmutableBranch(null, this.name, this.metadata, this.hash));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Branch, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Branch", generator="Immutables")
    static final class Json
    implements Branch {
        @Nullable
        String name;
        @Nullable
        ReferenceMetadata metadata;
        @Nullable
        String hash;

        Json() {
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(ReferenceMetadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="hash")
        public void setHash(String hash) {
            this.hash = hash;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceMetadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHash() {
            throw new UnsupportedOperationException();
        }
    }
}

