/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Validation {
    public static final String HASH_RAW_REGEX = "[0-9a-fA-F]{8,64}";
    public static final String HASH_REGEX = "^[0-9a-fA-F]{8,64}$";
    public static final String RELATIVE_COMMIT_SPEC_RAW_REGEX = "([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+))";
    public static final String HASH_OR_RELATIVE_COMMIT_SPEC_RAW_REGEX = "([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)";
    public static final String HASH_OR_RELATIVE_COMMIT_SPEC_REGEX = "^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$";
    public static final String REF_NAME_RAW_REGEX = "(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-";
    public static final String REF_NAME_REGEX = "^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$";
    public static final String REF_TYPE_RAW_REGEX = "BRANCH|branch|TAG|tag";
    public static final String REF_TYPE_REGEX = "^(BRANCH|branch|TAG|tag)$";
    public static final String REF_NAME_OR_HASH_REGEX = "^(?:([0-9a-fA-F]{8,64})|((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-))$";
    public static final String REF_NAME_PATH_REGEX = "^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$";
    public static final String REF_NAME_PATH_ELEMENT_REGEX = "([^/]+|[^@]+(@|%40)[^@/]*)";
    public static final Pattern HASH_PATTERN = Pattern.compile("^[0-9a-fA-F]{8,64}$");
    public static final Pattern REF_NAME_PATTERN = Pattern.compile("^(?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-$");
    public static final Pattern RELATIVE_COMMIT_SPEC_PART_PATTERN = Pattern.compile("([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+))");
    public static final Pattern HASH_OR_RELATIVE_COMMIT_SPEC_PATTERN = Pattern.compile("^([0-9a-fA-F]{8,64})?((?:([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*)$");
    public static final Pattern REF_NAME_OR_HASH_PATTERN = Pattern.compile("^(?:([0-9a-fA-F]{8,64})|((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-))$");
    public static final Pattern REF_NAME_PATH_PATTERN = Pattern.compile("^((?:[A-Za-z](?:(?:(?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?)|-)?(?:@([0-9a-fA-F]{8,64})?)?(([~*^])([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2}[.][0-9]{1,9}Z|([0-9]+)))*$");
    public static final Pattern REF_NAME_PATH_ELEMENT_PATTERN = Pattern.compile("([^/]+|[^@]+(@|%40)[^@/]*)");
    private static final String DURATION_REGEX = "([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?";
    private static final String ISO_TIME_REGEX = "^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:\\.\\d{1,9})?(?:Z|[+-][01]\\d:[0-5]\\d)$";
    private static final String POSITIVE_INTEGER_REGEX = "^[1-9]\\d{0,10}";
    public static final String DEFAULT_CUT_OFF_POLICY_REGEX = "NONE|^[1-9]\\d{0,10}|([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?|^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:\\.\\d{1,9})?(?:Z|[+-][01]\\d:[0-5]\\d)$";
    public static final String DEFAULT_CUT_OFF_POLICY_MESSAGE = "Default cut-off-policy must be either the number of commits, a duration (as per java.time.Duration) or an ISO instant (like 2011-12-03T10:15:30Z) ";
    public static final Pattern DEFAULT_CUT_OFF_POLICY_PATTERN = Pattern.compile("NONE|^[1-9]\\d{0,10}|([-+]?)P(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,9}))?S)?)?|^(?:[1-9]\\d{3}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1\\d|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[1-9]\\d(?:0[48]|[2468][048]|[13579][26])|(?:[2468][048]|[13579][26])00)-02-29)T(?:[01]\\d|2[0-3]):[0-5]\\d:[0-5]\\d(?:\\.\\d{1,9})?(?:Z|[+-][01]\\d:[0-5]\\d)$", 2);
    public static final String HASH_RULE = "consist of the hex representation of 4-32 bytes";
    private static final String REF_RULE = "start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'";
    public static final String HASH_MESSAGE = "Hash must consist of the hex representation of 4-32 bytes";
    public static final String RELATIVE_COMMIT_SPEC_RULE = "be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format";
    public static final String HASH_OR_RELATIVE_COMMIT_SPEC_RULE = "consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.";
    public static final String HASH_OR_RELATIVE_COMMIT_SPEC_MESSAGE = "Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.";
    public static final String REF_NAME_PATH_MESSAGE = "Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..', optionally followed by @ and a hash with optional relative part. Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both.";
    public static final String REF_NAME_MESSAGE = "Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'";
    public static final String REF_TYPE_RULE = "be either 'branch' or 'tag'";
    public static final String REF_TYPE_MESSAGE = "Reference type name must be either 'branch' or 'tag'";
    public static final String REF_NAME_OR_HASH_MESSAGE = "Reference must be either a reference name or hash, start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..' or consist of the hex representation of 4-32 bytes";
    public static final String FORBIDDEN_REF_NAME_MESSAGE = "Reference name mut not be HEAD, DETACHED or a potential commit ID representation.";
    public static final Set<String> FORBIDDEN_REF_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("HEAD", "DETACHED")));

    private Validation() {
    }

    public static boolean isValidReferenceName(String referenceName) {
        Objects.requireNonNull(referenceName, "referenceName must not be null");
        Matcher matcher = REF_NAME_PATTERN.matcher(referenceName);
        return matcher.matches();
    }

    public static boolean isValidHash(String hash) {
        Objects.requireNonNull(hash, "hash must not be null");
        Matcher matcher = HASH_PATTERN.matcher(hash);
        return matcher.matches();
    }

    public static boolean isValidHashOrRelativeSpec(String hash) {
        Objects.requireNonNull(hash, "hash must not be null");
        if (hash.isEmpty()) {
            return false;
        }
        Matcher matcher = HASH_OR_RELATIVE_COMMIT_SPEC_PATTERN.matcher(hash);
        return matcher.matches();
    }

    public static boolean isValidReferenceNameOrHash(String ref) {
        Objects.requireNonNull(ref, "reference (name or hash) must not be null");
        Matcher matcher = REF_NAME_OR_HASH_PATTERN.matcher(ref);
        return matcher.matches();
    }

    public static String validateReferenceName(String referenceName) throws IllegalArgumentException {
        if (Validation.isValidReferenceName(referenceName)) {
            return referenceName;
        }
        throw new IllegalArgumentException("Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..' - but was: " + referenceName);
    }

    public static String validateHash(String referenceName) throws IllegalArgumentException {
        if (Validation.isValidHash(referenceName)) {
            return referenceName;
        }
        throw new IllegalArgumentException("Hash must consist of the hex representation of 4-32 bytes - but was: " + referenceName);
    }

    public static String validateHashOrRelativeSpec(String referenceName) throws IllegalArgumentException {
        if (Validation.isValidHashOrRelativeSpec(referenceName)) {
            return referenceName;
        }
        throw new IllegalArgumentException("Hash with optional relative part must consist of either a valid commit hash (which in turn must consist of the hex representation of 4-32 bytes), or a valid relative part (which must be either '~' + a number representing the n-th predecessor of a commit, '^' + a number representing the n-th parent within a commit, or '*' + a number representing the created timestamp of a commit, in milliseconds since epoch or in ISO-8601 format), or both. - but was: " + referenceName);
    }

    private static boolean isValidDefaultCutoffPolicy(String policy) {
        Objects.requireNonNull(policy, "policy must not be null");
        Matcher matcher = DEFAULT_CUT_OFF_POLICY_PATTERN.matcher(policy);
        return matcher.matches();
    }

    public static void validateDefaultCutOffPolicy(String value) {
        if (Validation.isValidDefaultCutoffPolicy(value)) {
            return;
        }
        throw new IllegalArgumentException("Failed to parse default-cutoff-value '" + value + "'," + DEFAULT_CUT_OFF_POLICY_MESSAGE);
    }

    public static String validateReferenceNameOrHash(String ref) throws IllegalArgumentException {
        if (Validation.isValidReferenceNameOrHash(ref)) {
            return ref;
        }
        throw new IllegalArgumentException("Reference must be either a reference name or hash, start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..' or consist of the hex representation of 4-32 bytes - but was: " + ref);
    }

    public static boolean isForbiddenReferenceName(String ref) {
        return FORBIDDEN_REF_NAMES.contains(ref.toUpperCase(Locale.ROOT)) || HASH_PATTERN.matcher(ref).matches();
    }

    public static String validateForbiddenReferenceName(String ref) throws IllegalArgumentException {
        if (Validation.isForbiddenReferenceName(ref)) {
            throw new IllegalArgumentException("Reference name mut not be HEAD, DETACHED or a potential commit ID representation. - but was " + ref);
        }
        return ref;
    }
}

