/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Table;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdatePartitionStatistics;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.UpdateStatistics;

abstract class BaseReadOnlyTable
implements Table {
    private final String descriptor;

    BaseReadOnlyTable(String descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public UpdateSchema updateSchema() {
        throw new UnsupportedOperationException("Cannot update the schema of a " + this.descriptor + " table");
    }

    @Override
    public UpdatePartitionSpec updateSpec() {
        throw new UnsupportedOperationException("Cannot update the partition spec of a " + this.descriptor + " table");
    }

    @Override
    public UpdateProperties updateProperties() {
        throw new UnsupportedOperationException("Cannot update the properties of a " + this.descriptor + " table");
    }

    @Override
    public ReplaceSortOrder replaceSortOrder() {
        throw new UnsupportedOperationException("Cannot update the sort order of a " + this.descriptor + " table");
    }

    @Override
    public UpdateLocation updateLocation() {
        throw new UnsupportedOperationException("Cannot update the location of a " + this.descriptor + " table");
    }

    @Override
    public AppendFiles newAppend() {
        throw new UnsupportedOperationException("Cannot append to a " + this.descriptor + " table");
    }

    @Override
    public RewriteFiles newRewrite() {
        throw new UnsupportedOperationException("Cannot rewrite in a " + this.descriptor + " table");
    }

    @Override
    public RewriteManifests rewriteManifests() {
        throw new UnsupportedOperationException("Cannot rewrite manifests in a " + this.descriptor + " table");
    }

    @Override
    public OverwriteFiles newOverwrite() {
        throw new UnsupportedOperationException("Cannot overwrite in a " + this.descriptor + " table");
    }

    @Override
    public RowDelta newRowDelta() {
        throw new UnsupportedOperationException("Cannot remove or replace rows in a " + this.descriptor + " table");
    }

    @Override
    public ReplacePartitions newReplacePartitions() {
        throw new UnsupportedOperationException("Cannot replace partitions in a " + this.descriptor + " table");
    }

    @Override
    public DeleteFiles newDelete() {
        throw new UnsupportedOperationException("Cannot delete from a " + this.descriptor + " table");
    }

    @Override
    public UpdateStatistics updateStatistics() {
        throw new UnsupportedOperationException("Cannot update statistics of a " + this.descriptor + " table");
    }

    @Override
    public UpdatePartitionStatistics updatePartitionStatistics() {
        throw new UnsupportedOperationException("Cannot update partition statistics of a " + this.descriptor + " table");
    }

    @Override
    public ExpireSnapshots expireSnapshots() {
        throw new UnsupportedOperationException("Cannot expire snapshots from a " + this.descriptor + " table");
    }

    @Override
    public ManageSnapshots manageSnapshots() {
        throw new UnsupportedOperationException("Cannot manage snapshots in a " + this.descriptor + " table");
    }

    @Override
    public Transaction newTransaction() {
        throw new UnsupportedOperationException("Cannot create transactions for a " + this.descriptor + " table");
    }
}

