/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Supplier;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.avro.Schema;

abstract class AvroCustomOrderSchemaVisitor<T, F> {
    private final Deque<String> recordLevels = Lists.newLinkedList();

    AvroCustomOrderSchemaVisitor() {
    }

    public static <T, F> T visit(Schema schema, AvroCustomOrderSchemaVisitor<T, F> visitor) {
        switch (schema.getType()) {
            case RECORD: {
                String name = schema.getFullName();
                Preconditions.checkState(!visitor.recordLevels.contains(name), "Cannot process recursive Avro record %s", (Object)name);
                visitor.recordLevels.push(name);
                List<Schema.Field> fields = schema.getFields();
                ArrayList<String> names = Lists.newArrayListWithExpectedSize(fields.size());
                ArrayList results = Lists.newArrayListWithExpectedSize(fields.size());
                for (Schema.Field field : schema.getFields()) {
                    names.add(field.name());
                    results.add(new VisitFieldFuture(field, visitor));
                }
                visitor.recordLevels.pop();
                return visitor.record(schema, names, Iterables.transform(results, Supplier::get));
            }
            case UNION: {
                List<Schema> types = schema.getTypes();
                ArrayList options = Lists.newArrayListWithExpectedSize(types.size());
                for (Schema type : types) {
                    options.add(new VisitFuture(type, visitor));
                }
                return visitor.union(schema, Iterables.transform(options, Supplier::get));
            }
            case ARRAY: {
                return visitor.array(schema, new VisitFuture(schema.getElementType(), visitor));
            }
            case MAP: {
                return visitor.map(schema, new VisitFuture(schema.getValueType(), visitor));
            }
        }
        return visitor.primitive(schema);
    }

    public T record(Schema record, List<String> names, Iterable<F> fields) {
        return null;
    }

    public F field(Schema.Field field, Supplier<T> fieldResult) {
        return null;
    }

    public T union(Schema union, Iterable<T> options) {
        return null;
    }

    public T array(Schema array, Supplier<T> element) {
        return null;
    }

    public T map(Schema map, Supplier<T> value) {
        return null;
    }

    public T primitive(Schema primitive) {
        return null;
    }

    private static class VisitFieldFuture<T, F>
    implements Supplier<F> {
        private final Schema.Field field;
        private final AvroCustomOrderSchemaVisitor<T, F> visitor;

        private VisitFieldFuture(Schema.Field field, AvroCustomOrderSchemaVisitor<T, F> visitor) {
            this.field = field;
            this.visitor = visitor;
        }

        @Override
        public F get() {
            return this.visitor.field(this.field, new VisitFuture(this.field.schema(), this.visitor));
        }
    }

    private static class VisitFuture<T, F>
    implements Supplier<T> {
        private final Schema schema;
        private final AvroCustomOrderSchemaVisitor<T, F> visitor;

        private VisitFuture(Schema schema, AvroCustomOrderSchemaVisitor<T, F> visitor) {
            this.schema = schema;
            this.visitor = visitor;
        }

        @Override
        public T get() {
            return AvroCustomOrderSchemaVisitor.visit(this.schema, this.visitor);
        }
    }
}

