/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.serde.objectinspector;

import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.iceberg.mr.hive.serde.objectinspector.WriteObjectInspector;

public class IcebergTimestampWithZoneObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements TimestampObjectInspector,
WriteObjectInspector {
    private static final IcebergTimestampWithZoneObjectInspector INSTANCE = new IcebergTimestampWithZoneObjectInspector();

    public static IcebergTimestampWithZoneObjectInspector get() {
        return INSTANCE;
    }

    private IcebergTimestampWithZoneObjectInspector() {
        super(TypeInfoFactory.timestampTypeInfo);
    }

    @Override
    public OffsetDateTime convert(Object o) {
        return o == null ? null : OffsetDateTime.ofInstant(((Timestamp)o).toInstant(), ZoneOffset.UTC);
    }

    public Timestamp getPrimitiveJavaObject(Object o) {
        return o == null ? null : Timestamp.from(((OffsetDateTime)o).toInstant());
    }

    public TimestampWritable getPrimitiveWritableObject(Object o) {
        Timestamp ts = this.getPrimitiveJavaObject(o);
        return ts == null ? null : new TimestampWritable(ts);
    }

    public Object copyObject(Object o) {
        if (o instanceof Timestamp) {
            Timestamp ts = (Timestamp)o;
            Timestamp copy = new Timestamp(ts.getTime());
            copy.setNanos(ts.getNanos());
            return copy;
        }
        if (o instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)o;
            return OffsetDateTime.ofInstant(odt.toInstant(), odt.getOffset());
        }
        return o;
    }
}

