/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import org.apache.iceberg.Schema;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;

class AssignIds
extends TypeUtil.CustomOrderSchemaVisitor<Type> {
    private final TypeUtil.GetID getID;

    AssignIds(TypeUtil.GetID getID) {
        this.getID = getID;
    }

    private int idFor(int id) {
        return this.getID.get(id);
    }

    @Override
    public Type schema(Schema schema, Supplier<Type> future) {
        return future.get();
    }

    @Override
    public Type struct(Types.StructType struct, Iterable<Type> futures) {
        List<Types.NestedField> fields = struct.fields();
        int length = struct.fields().size();
        ArrayList<Integer> newIds = Lists.newArrayListWithExpectedSize(length);
        for (Types.NestedField field : fields) {
            newIds.add(this.idFor(field.fieldId()));
        }
        ArrayList<Types.NestedField> newFields = Lists.newArrayListWithExpectedSize(length);
        Iterator<Type> types = futures.iterator();
        for (int i = 0; i < length; ++i) {
            Types.NestedField field = fields.get(i);
            Type type = types.next();
            if (field.isOptional()) {
                newFields.add(Types.NestedField.optional((Integer)newIds.get(i), field.name(), type, field.doc()));
                continue;
            }
            newFields.add(Types.NestedField.required((Integer)newIds.get(i), field.name(), type, field.doc()));
        }
        return Types.StructType.of(newFields);
    }

    @Override
    public Type field(Types.NestedField field, Supplier<Type> future) {
        return future.get();
    }

    @Override
    public Type list(Types.ListType list, Supplier<Type> future) {
        int newId = this.idFor(list.elementId());
        if (list.isElementOptional()) {
            return Types.ListType.ofOptional(newId, future.get());
        }
        return Types.ListType.ofRequired(newId, future.get());
    }

    @Override
    public Type map(Types.MapType map, Supplier<Type> keyFuture, Supplier<Type> valueFuture) {
        int newKeyId = this.idFor(map.keyId());
        int newValueId = this.idFor(map.valueId());
        if (map.isValueOptional()) {
            return Types.MapType.ofOptional(newKeyId, newValueId, keyFuture.get(), valueFuture.get());
        }
        return Types.MapType.ofRequired(newKeyId, newValueId, keyFuture.get(), valueFuture.get());
    }

    @Override
    public Type primitive(Type.PrimitiveType primitive) {
        return primitive;
    }
}

