/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.net.URI;
import java.util.Optional;
import org.projectnessie.client.auth.oauth2.ImpersonationConfig;
import org.projectnessie.client.auth.oauth2.OAuth2ClientConfig;
import org.projectnessie.client.auth.oauth2.TokenExchangeFlow;
import org.projectnessie.client.auth.oauth2.Tokens;
import org.projectnessie.client.http.HttpAuthentication;

class ImpersonationFlow
extends TokenExchangeFlow {
    private final ImpersonationConfig impersonationConfig;

    ImpersonationFlow(OAuth2ClientConfig config) {
        super(config);
        this.impersonationConfig = config.getImpersonationConfig();
    }

    @Override
    public Tokens fetchNewTokens(Tokens currentTokens) {
        Tokens newTokens = super.fetchNewTokens(currentTokens);
        return Tokens.of(newTokens.getAccessToken(), currentTokens.getRefreshToken());
    }

    @Override
    Optional<String> getScope() {
        if (!this.impersonationConfig.getScopes().equals(ImpersonationConfig.SCOPES_INHERIT)) {
            return this.impersonationConfig.getScopes().stream().reduce((a, b) -> a + " " + b);
        }
        return super.getScope();
    }

    @Override
    URI getResolvedTokenEndpoint() {
        if (this.impersonationConfig.getIssuerUrl().isPresent() || this.impersonationConfig.getTokenEndpoint().isPresent()) {
            return this.config.getResolvedImpersonationTokenEndpoint();
        }
        return super.getResolvedTokenEndpoint();
    }

    @Override
    String getClientId() {
        if (this.impersonationConfig.getClientId().isPresent()) {
            return this.impersonationConfig.getClientId().get();
        }
        return super.getClientId();
    }

    @Override
    boolean isPublicClient() {
        if (this.impersonationConfig.getClientId().isPresent()) {
            return !this.impersonationConfig.getClientSecret().isPresent();
        }
        return super.isPublicClient();
    }

    @Override
    Optional<HttpAuthentication> getBasicAuthentication() {
        if (this.impersonationConfig.getClientId().isPresent()) {
            return this.config.getImpersonationBasicAuthentication();
        }
        return super.getBasicAuthentication();
    }
}

