/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.AvroSchemaVisitor;
import org.apache.iceberg.avro.LogicalMap;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.shaded.org.apache.avro.JsonProperties;
import org.apache.iceberg.shaded.org.apache.avro.Schema;
import org.apache.iceberg.shaded.org.apache.avro.SchemaNormalization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PruneColumns
extends AvroSchemaVisitor<Schema> {
    private static final Logger LOG = LoggerFactory.getLogger(PruneColumns.class);
    private final Set<Integer> selectedIds;
    private final NameMapping nameMapping;

    PruneColumns(Set<Integer> selectedIds, NameMapping nameMapping) {
        Preconditions.checkNotNull(selectedIds, "Selected field ids cannot be null");
        this.selectedIds = selectedIds;
        this.nameMapping = nameMapping;
    }

    Schema rootSchema(Schema record) {
        Schema result = PruneColumns.visit(record, this);
        if (result != null) {
            return result;
        }
        return PruneColumns.copyRecord(record, ImmutableList.of());
    }

    @Override
    public Schema record(Schema record, List<String> names, List<Schema> fields) {
        ArrayList<Schema.Field> filteredFields = Lists.newArrayListWithExpectedSize(fields.size());
        boolean hasChange = false;
        for (Schema.Field field : record.getFields()) {
            Integer fieldId = AvroSchemaUtil.getFieldId(field, this.nameMapping, this.fieldNames());
            if (fieldId == null) continue;
            if (!AvroSchemaUtil.hasFieldId(field)) {
                hasChange = true;
            }
            if (PruneColumns.isOptionSchemaWithNonNullFirstOption(field.schema())) {
                hasChange = true;
            }
            Schema fieldSchema = fields.get(field.pos());
            if (this.selectedIds.contains(fieldId)) {
                if (fieldSchema != null) {
                    hasChange = true;
                    filteredFields.add(PruneColumns.copyField(field, fieldSchema, fieldId));
                    continue;
                }
                if (this.isRecord(field.schema())) {
                    hasChange = true;
                    filteredFields.add(PruneColumns.copyField(field, PruneColumns.makeEmptyCopy(field.schema()), fieldId));
                    continue;
                }
                filteredFields.add(PruneColumns.copyField(field, field.schema(), fieldId));
                continue;
            }
            if (fieldSchema == null) continue;
            hasChange = true;
            filteredFields.add(PruneColumns.copyField(field, fieldSchema, fieldId));
        }
        if (hasChange) {
            return PruneColumns.copyRecord(record, filteredFields);
        }
        if (filteredFields.size() == record.getFields().size()) {
            return record;
        }
        if (!filteredFields.isEmpty()) {
            return PruneColumns.copyRecord(record, filteredFields);
        }
        return null;
    }

    @Override
    public Schema union(Schema union, List<Schema> options) {
        Preconditions.checkState(AvroSchemaUtil.isOptionSchema(union), "Invalid schema: non-option unions are not supported: %s", (Object)union);
        Schema pruned = null;
        if (options.get(0) != null) {
            pruned = options.get(0);
        } else if (options.get(1) != null) {
            pruned = options.get(1);
        }
        if (pruned != null) {
            if (!Objects.equals(pruned, AvroSchemaUtil.fromOption(union))) {
                return AvroSchemaUtil.toOption(pruned);
            }
            return union;
        }
        return null;
    }

    @Override
    public Schema array(Schema array, Schema element) {
        if (array.getLogicalType() instanceof LogicalMap) {
            Schema keyValue = array.getElementType();
            Integer keyId = AvroSchemaUtil.getFieldId(keyValue.getField("key"), this.nameMapping, this.fieldNames());
            Integer valueId = AvroSchemaUtil.getFieldId(keyValue.getField("value"), this.nameMapping, this.fieldNames());
            if (keyId == null || valueId == null) {
                if (keyId != null || valueId != null) {
                    LOG.warn("Map schema {} should have both key and value ids set or both unset", (Object)array);
                }
                return null;
            }
            if (this.selectedIds.contains(keyId) || this.selectedIds.contains(valueId)) {
                return this.complexMapWithIds(array, keyId, valueId);
            }
            if (element != null) {
                Schema.Field keyProjectionField = element.getField("key");
                Schema valueProjection = element.getField("value").schema();
                if (keyProjectionField != null && !Objects.equals(keyValue.getField("key").schema(), keyProjectionField.schema())) {
                    Preconditions.checkState(SchemaNormalization.parsingFingerprint64(keyValue.getField("key").schema()) == SchemaNormalization.parsingFingerprint64(keyProjectionField.schema()), "Map keys should not be projected");
                    return AvroSchemaUtil.createMap(keyId, keyProjectionField.schema(), valueId, valueProjection);
                }
                if (!Objects.equals(keyValue.getField("value").schema(), valueProjection)) {
                    return AvroSchemaUtil.createMap(keyId, keyValue.getField("key").schema(), valueId, valueProjection);
                }
                return this.complexMapWithIds(array, keyId, valueId);
            }
        } else {
            Integer elementId = AvroSchemaUtil.getElementId(array, this.nameMapping, this.fieldNames());
            if (elementId == null) {
                return null;
            }
            if (this.selectedIds.contains(elementId)) {
                return this.arrayWithId(array, elementId);
            }
            if (element != null) {
                if (!Objects.equals(element, array.getElementType())) {
                    return this.arrayWithId(Schema.createArray(element), elementId);
                }
                return this.arrayWithId(array, elementId);
            }
        }
        return null;
    }

    @Override
    public Schema map(Schema map, Schema value) {
        Integer keyId = AvroSchemaUtil.getKeyId(map, this.nameMapping, this.fieldNames());
        Integer valueId = AvroSchemaUtil.getValueId(map, this.nameMapping, this.fieldNames());
        if (keyId == null || valueId == null) {
            if (keyId != null || valueId != null) {
                LOG.warn("Map schema {} should have both key and value ids set or both unset", (Object)map);
            }
            return null;
        }
        if (this.selectedIds.contains(keyId) || this.selectedIds.contains(valueId)) {
            return this.mapWithIds(map, keyId, valueId);
        }
        if (value != null) {
            if (!Objects.equals(value, map.getValueType())) {
                return this.mapWithIds(Schema.createMap(value), keyId, valueId);
            }
            return map;
        }
        return null;
    }

    private Schema arrayWithId(Schema array, Integer elementId) {
        if (!AvroSchemaUtil.hasProperty(array, "element-id")) {
            Schema result = Schema.createArray(array.getElementType());
            result.addProp("element-id", elementId);
            return result;
        }
        return array;
    }

    private Schema complexMapWithIds(Schema map, Integer keyId, Integer valueId) {
        Schema keyValue = map.getElementType();
        if (!AvroSchemaUtil.hasFieldId(keyValue.getField("key")) || !AvroSchemaUtil.hasFieldId(keyValue.getField("value"))) {
            return AvroSchemaUtil.createMap(keyId, keyValue.getField("key").schema(), valueId, keyValue.getField("value").schema());
        }
        return map;
    }

    private Schema mapWithIds(Schema map, Integer keyId, Integer valueId) {
        if (!AvroSchemaUtil.hasProperty(map, "key-id") || !AvroSchemaUtil.hasProperty(map, "value-id")) {
            Schema result = Schema.createMap(map.getValueType());
            result.addProp("key-id", keyId);
            result.addProp("value-id", valueId);
            return result;
        }
        return map;
    }

    @Override
    public Schema primitive(Schema primitive) {
        return null;
    }

    private static Schema copyRecord(Schema record, List<Schema.Field> newFields) {
        Schema copy = Schema.createRecord(record.getName(), record.getDoc(), record.getNamespace(), record.isError(), newFields);
        for (Map.Entry<String, Object> prop : record.getObjectProps().entrySet()) {
            copy.addProp(prop.getKey(), prop.getValue());
        }
        return copy;
    }

    private boolean isRecord(Schema field) {
        if (AvroSchemaUtil.isOptionSchema(field)) {
            return AvroSchemaUtil.fromOption(field).getType().equals((Object)Schema.Type.RECORD);
        }
        return field.getType().equals((Object)Schema.Type.RECORD);
    }

    private static Schema makeEmptyCopy(Schema field) {
        if (AvroSchemaUtil.isOptionSchema(field)) {
            Schema innerSchema = AvroSchemaUtil.fromOption(field);
            Schema emptyRecord = Schema.createRecord(innerSchema.getName(), innerSchema.getDoc(), innerSchema.getNamespace(), innerSchema.isError(), Collections.emptyList());
            return AvroSchemaUtil.toOption(emptyRecord);
        }
        return Schema.createRecord(field.getName(), field.getDoc(), field.getNamespace(), field.isError(), Collections.emptyList());
    }

    private static Schema.Field copyField(Schema.Field field, Schema newSchema, Integer fieldId) {
        Schema newSchemaReordered = PruneColumns.isOptionSchemaWithNonNullFirstOption(newSchema) ? AvroSchemaUtil.toOption(AvroSchemaUtil.fromOption(newSchema)) : newSchema;
        Schema.Field copy = new Schema.Field(field.name(), newSchemaReordered, field.doc(), AvroSchemaUtil.isOptionSchema(newSchemaReordered) ? JsonProperties.NULL_VALUE : null, field.order());
        for (Map.Entry<String, Object> prop : field.getObjectProps().entrySet()) {
            copy.addProp(prop.getKey(), prop.getValue());
        }
        if (AvroSchemaUtil.hasFieldId(field)) {
            int existingFieldId = AvroSchemaUtil.getFieldId(field);
            Preconditions.checkArgument(existingFieldId == fieldId, "Existing field does match with that fetched from name mapping");
        } else {
            copy.addProp("field-id", fieldId);
        }
        return copy;
    }

    private static boolean isOptionSchemaWithNonNullFirstOption(Schema schema) {
        return AvroSchemaUtil.isOptionSchema(schema) && schema.getTypes().get(0).getType() != Schema.Type.NULL;
    }
}

