/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.iceberg.metrics.ImmutableTimerResult;
import org.apache.iceberg.metrics.Timer;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.immutables.value.Value;

@Value.Immutable
public interface TimerResult {
    public TimeUnit timeUnit();

    public Duration totalDuration();

    public long count();

    public static TimerResult fromTimer(Timer timer) {
        Preconditions.checkArgument(null != timer, "Invalid timer: null");
        if (timer.isNoop()) {
            return null;
        }
        return ImmutableTimerResult.builder().timeUnit(timer.unit()).totalDuration(timer.totalDuration()).count(timer.count()).build();
    }

    public static TimerResult of(TimeUnit timeUnit, Duration duration, long count) {
        return ImmutableTimerResult.builder().timeUnit(timeUnit).totalDuration(duration).count(count).build();
    }
}

