/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.vector;

import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.mapred.JobConf;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompatibilityHiveVectorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CompatibilityHiveVectorUtils.class);

    private CompatibilityHiveVectorUtils() {
    }

    public static MapWork findMapWork(JobConf job) {
        String prefixes;
        String inputName = job.get("iocontext.input.name", null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing for input {}", (Object)inputName);
        }
        if ((prefixes = job.get("hive.tez.merge.file.prefixes")) != null && !prefixes.trim().isEmpty()) {
            return null;
        }
        BaseWork work = null;
        if (!(inputName == null || prefixes != null && Lists.newArrayList(prefixes.split(",")).contains(inputName))) {
            inputName = null;
        }
        if (inputName != null) {
            work = Utilities.getMergeWork((Configuration)job, (String)inputName);
        }
        if (!(work instanceof MapWork)) {
            work = Utilities.getMapWork((Configuration)job);
        }
        return (MapWork)work;
    }

    public static void addPartitionColsToBatch(ColumnVector col, Object value, String partitionColumnName, TypeInfo rowColumnTypeInfo) {
        PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)rowColumnTypeInfo;
        if (value == null) {
            col.noNulls = false;
            col.isNull[0] = true;
            col.isRepeating = true;
            return;
        }
        switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case BOOLEAN: {
                LongColumnVector booleanColumnVector = (LongColumnVector)col;
                booleanColumnVector.fill((Boolean)value != false ? 1L : 0L);
                booleanColumnVector.isNull[0] = false;
                break;
            }
            case BYTE: {
                LongColumnVector byteColumnVector = (LongColumnVector)col;
                byteColumnVector.fill((long)((Byte)value).byteValue());
                byteColumnVector.isNull[0] = false;
                break;
            }
            case SHORT: {
                LongColumnVector shortColumnVector = (LongColumnVector)col;
                shortColumnVector.fill((long)((Short)value).shortValue());
                shortColumnVector.isNull[0] = false;
                break;
            }
            case INT: {
                LongColumnVector intColumnVector = (LongColumnVector)col;
                intColumnVector.fill((long)((Integer)value).intValue());
                intColumnVector.isNull[0] = false;
                break;
            }
            case LONG: {
                LongColumnVector longColumnVector = (LongColumnVector)col;
                longColumnVector.fill(((Long)value).longValue());
                longColumnVector.isNull[0] = false;
                break;
            }
            case DATE: {
                LongColumnVector dateColumnVector = (LongColumnVector)col;
                dateColumnVector.fill((long)DateWritable.dateToDays((Date)((Date)value)));
                dateColumnVector.isNull[0] = false;
                break;
            }
            case TIMESTAMP: {
                TimestampColumnVector timeStampColumnVector = (TimestampColumnVector)col;
                timeStampColumnVector.fill((Timestamp)value);
                timeStampColumnVector.isNull[0] = false;
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                LongColumnVector intervalYearMonthColumnVector = (LongColumnVector)col;
                intervalYearMonthColumnVector.fill((long)((HiveIntervalYearMonth)value).getTotalMonths());
                intervalYearMonthColumnVector.isNull[0] = false;
                break;
            }
            case INTERVAL_DAY_TIME: {
                IntervalDayTimeColumnVector intervalDayTimeColumnVector = (IntervalDayTimeColumnVector)col;
                intervalDayTimeColumnVector.fill((HiveIntervalDayTime)value);
                intervalDayTimeColumnVector.isNull[0] = false;
                break;
            }
            case FLOAT: {
                DoubleColumnVector floatColumnVector = (DoubleColumnVector)col;
                floatColumnVector.fill((double)((Float)value).floatValue());
                floatColumnVector.isNull[0] = false;
                break;
            }
            case DOUBLE: {
                DoubleColumnVector doubleColumnVector = (DoubleColumnVector)col;
                doubleColumnVector.fill(((Double)value).doubleValue());
                doubleColumnVector.isNull[0] = false;
                break;
            }
            case DECIMAL: {
                DecimalColumnVector decimalColumnVector = (DecimalColumnVector)col;
                HiveDecimal hd = (HiveDecimal)value;
                decimalColumnVector.set(0, hd);
                decimalColumnVector.isRepeating = true;
                decimalColumnVector.isNull[0] = false;
                break;
            }
            case BINARY: {
                BytesColumnVector binaryColumnVector = (BytesColumnVector)col;
                byte[] bytes = (byte[])value;
                binaryColumnVector.fill(bytes);
                binaryColumnVector.isNull[0] = false;
                break;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                BytesColumnVector bytesColumnVector = (BytesColumnVector)col;
                String sVal = value.toString();
                if (sVal == null) {
                    bytesColumnVector.noNulls = false;
                    bytesColumnVector.isNull[0] = true;
                    bytesColumnVector.isRepeating = true;
                    break;
                }
                bytesColumnVector.setVal(0, sVal.getBytes(StandardCharsets.UTF_8));
                bytesColumnVector.isRepeating = true;
                break;
            }
            default: {
                throw new RuntimeException("Unable to recognize the partition type " + primitiveTypeInfo.getPrimitiveCategory() + " for column " + partitionColumnName);
            }
        }
    }
}

