/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.iceberg.IcebergBuild;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.exceptions.RESTException;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.rest.ErrorHandler;
import org.apache.iceberg.rest.ExponentialHttpRequestRetryStrategy;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.RESTObjectMapper;
import org.apache.iceberg.rest.RESTRequest;
import org.apache.iceberg.rest.RESTResponse;
import org.apache.iceberg.rest.RESTUtil;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.iceberg.shaded.org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.ContentType;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.Header;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.HttpHost;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.Method;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.ParseException;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.impl.EnglishReasonPhraseCatalog;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.message.BasicHeader;
import org.apache.iceberg.shaded.org.apache.hc.core5.io.CloseMode;
import org.apache.iceberg.shaded.org.apache.hc.core5.net.URIBuilder;
import org.apache.iceberg.util.PropertyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPClient
implements RESTClient {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPClient.class);
    private static final String SIGV4_ENABLED = "rest.sigv4-enabled";
    private static final String SIGV4_REQUEST_INTERCEPTOR_IMPL = "org.apache.iceberg.aws.RESTSigV4Signer";
    @VisibleForTesting
    static final String CLIENT_VERSION_HEADER = "X-Client-Version";
    @VisibleForTesting
    static final String CLIENT_GIT_COMMIT_SHORT_HEADER = "X-Client-Git-Commit-Short";
    private static final String REST_MAX_RETRIES = "rest.client.max-retries";
    private static final String REST_MAX_CONNECTIONS = "rest.client.max-connections";
    private static final int REST_MAX_CONNECTIONS_DEFAULT = 100;
    private static final String REST_MAX_CONNECTIONS_PER_ROUTE = "rest.client.connections-per-route";
    private static final int REST_MAX_CONNECTIONS_PER_ROUTE_DEFAULT = 100;
    @VisibleForTesting
    static final String REST_CONNECTION_TIMEOUT_MS = "rest.client.connection-timeout-ms";
    @VisibleForTesting
    static final String REST_SOCKET_TIMEOUT_MS = "rest.client.socket-timeout-ms";
    private final String uri;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper mapper;

    private HTTPClient(String uri, HttpHost proxy, CredentialsProvider proxyCredsProvider, Map<String, String> baseHeaders, ObjectMapper objectMapper, HttpRequestInterceptor requestInterceptor, Map<String, String> properties, HttpClientConnectionManager connectionManager) {
        this.uri = uri;
        this.mapper = objectMapper;
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.setConnectionManager(connectionManager);
        if (baseHeaders != null) {
            clientBuilder.setDefaultHeaders(baseHeaders.entrySet().stream().map(e -> new BasicHeader((String)e.getKey(), e.getValue())).collect(Collectors.toList()));
        }
        if (requestInterceptor != null) {
            clientBuilder.addRequestInterceptorLast(requestInterceptor);
        }
        int maxRetries = PropertyUtil.propertyAsInt(properties, REST_MAX_RETRIES, 5);
        clientBuilder.setRetryStrategy(new ExponentialHttpRequestRetryStrategy(maxRetries));
        if (proxy != null) {
            if (proxyCredsProvider != null) {
                clientBuilder.setDefaultCredentialsProvider(proxyCredsProvider);
            }
            clientBuilder.setProxy(proxy);
        }
        this.httpClient = clientBuilder.build();
    }

    private static String extractResponseBodyAsString(CloseableHttpResponse response) {
        try {
            if (response.getEntity() == null) {
                return null;
            }
            return EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
        }
        catch (IOException | ParseException e) {
            throw new RESTException(e, "Failed to convert HTTP response body to string", new Object[0]);
        }
    }

    private static boolean isSuccessful(CloseableHttpResponse response) {
        int code = response.getCode();
        return code == 200 || code == 202 || code == 204;
    }

    private static ErrorResponse buildDefaultErrorResponse(CloseableHttpResponse response) {
        String responseReason = response.getReasonPhrase();
        String message = responseReason != null && !responseReason.isEmpty() ? responseReason : EnglishReasonPhraseCatalog.INSTANCE.getReason(response.getCode(), null);
        String type = "RESTException";
        return ErrorResponse.builder().responseCode(response.getCode()).withMessage(message).withType(type).build();
    }

    private static void throwFailure(CloseableHttpResponse response, String responseBody, Consumer<ErrorResponse> errorHandler) {
        ErrorResponse errorResponse = null;
        if (responseBody != null) {
            try {
                if (errorHandler instanceof ErrorHandler) {
                    errorResponse = ((ErrorHandler)errorHandler).parseResponse(response.getCode(), responseBody);
                } else {
                    LOG.warn("Unknown error handler {}, response body won't be parsed", (Object)errorHandler.getClass().getName());
                    errorResponse = ErrorResponse.builder().responseCode(response.getCode()).withMessage(responseBody).build();
                }
            }
            catch (UncheckedIOException | IllegalArgumentException e) {
                LOG.error("Failed to parse an error response. Will create one instead.", (Throwable)e);
            }
        }
        if (errorResponse == null) {
            errorResponse = HTTPClient.buildDefaultErrorResponse(response);
        }
        errorHandler.accept(errorResponse);
        throw new RESTException("Unhandled error: %s", errorResponse);
    }

    private URI buildUri(String path, Map<String, String> params) {
        if (path.startsWith("/")) {
            throw new RESTException("Received a malformed path for a REST request: %s. Paths should not start with /", path);
        }
        String fullPath = path.startsWith("https://") || path.startsWith("http://") ? path : String.format("%s/%s", this.uri, path);
        try {
            URIBuilder builder = new URIBuilder(fullPath);
            if (params != null) {
                params.forEach(builder::addParameter);
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new RESTException("Failed to create request URI from base %s, params %s", fullPath, params);
        }
    }

    private <T> T execute(Method method, String path, Map<String, String> queryParams, Object requestBody, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return this.execute(method, path, queryParams, requestBody, responseType, headers, errorHandler, h2 -> {});
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(Method method, String path, Map<String, String> queryParams, Object requestBody, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler, Consumer<Map<String, String>> responseHeaders) {
        HttpUriRequestBase request = new HttpUriRequestBase(method.name(), this.buildUri(path, queryParams));
        if (requestBody instanceof Map) {
            this.addRequestHeaders(request, headers, ContentType.APPLICATION_FORM_URLENCODED.getMimeType());
            request.setEntity(this.toFormEncoding((Map)requestBody));
        } else if (requestBody != null) {
            this.addRequestHeaders(request, headers, ContentType.APPLICATION_JSON.getMimeType());
            request.setEntity(this.toJson(requestBody));
        } else {
            this.addRequestHeaders(request, headers, ContentType.APPLICATION_JSON.getMimeType());
        }
        try {
            Throwable throwable = null;
            try (CloseableHttpResponse response = this.httpClient.execute(request);){
                T t2;
                HashMap<String, String> respHeaders = Maps.newHashMap();
                for (Header header : response.getHeaders()) {
                    respHeaders.put(header.getName(), header.getValue());
                }
                responseHeaders.accept(respHeaders);
                if (response.getCode() == 204 || responseType == null && HTTPClient.isSuccessful(response)) {
                    Header[] headerArray = null;
                    return (T)headerArray;
                }
                String responseBody = HTTPClient.extractResponseBodyAsString(response);
                if (!HTTPClient.isSuccessful(response)) {
                    HTTPClient.throwFailure(response, responseBody, errorHandler);
                }
                if (responseBody == null) {
                    throw new RESTException("Invalid (null) response body for request (expected %s): method=%s, path=%s, status=%d", responseType.getSimpleName(), method.name(), path, response.getCode());
                }
                try {
                    t2 = this.mapper.readValue(responseBody, responseType);
                }
                catch (JsonProcessingException e) {
                    try {
                        throw new RESTException(e, "Received a success response code of %d, but failed to parse response body into %s", response.getCode(), responseType.getSimpleName());
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                return t2;
            }
        }
        catch (IOException e) {
            throw new RESTException(e, "Error occurred while processing %s request", new Object[]{method});
        }
    }

    @Override
    public void head(String path, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        this.execute(Method.HEAD, path, null, null, null, headers, errorHandler);
    }

    @Override
    public <T extends RESTResponse> T get(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.GET, path, queryParams, null, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.POST, path, null, body, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T post(String path, RESTRequest body, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler, Consumer<Map<String, String>> responseHeaders) {
        return (T)((RESTResponse)this.execute(Method.POST, path, null, body, responseType, headers, errorHandler, responseHeaders));
    }

    @Override
    public <T extends RESTResponse> T delete(String path, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.DELETE, path, null, null, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T delete(String path, Map<String, String> queryParams, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.DELETE, path, queryParams, null, responseType, headers, errorHandler));
    }

    @Override
    public <T extends RESTResponse> T postForm(String path, Map<String, String> formData, Class<T> responseType, Map<String, String> headers, Consumer<ErrorResponse> errorHandler) {
        return (T)((RESTResponse)this.execute(Method.POST, path, null, formData, responseType, headers, errorHandler));
    }

    private void addRequestHeaders(HttpUriRequest request, Map<String, String> requestHeaders, String bodyMimeType) {
        request.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
        request.setHeader("Content-Type", bodyMimeType);
        requestHeaders.forEach(request::setHeader);
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close(CloseMode.GRACEFUL);
    }

    @VisibleForTesting
    static HttpRequestInterceptor loadInterceptorDynamically(String impl, Map<String, String> properties) {
        HttpRequestInterceptor instance;
        DynConstructors.Ctor ctor;
        try {
            ctor = DynConstructors.builder(HttpRequestInterceptor.class).loader(HTTPClient.class.getClassLoader()).impl(impl, new Class[0]).buildChecked();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize RequestInterceptor, missing no-arg constructor: %s", impl), e);
        }
        try {
            instance = (HttpRequestInterceptor)ctor.newInstance(new Object[0]);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(String.format("Cannot initialize, %s does not implement RequestInterceptor", impl), e);
        }
        DynMethods.builder("initialize").hiddenImpl(impl, Map.class).orNoop().build(instance).invoke(properties);
        return instance;
    }

    static HttpClientConnectionManager configureConnectionManager(Map<String, String> properties) {
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create();
        ConnectionConfig connectionConfig = HTTPClient.configureConnectionConfig(properties);
        if (connectionConfig != null) {
            connectionManagerBuilder.setDefaultConnectionConfig(connectionConfig);
        }
        return connectionManagerBuilder.useSystemProperties().setMaxConnTotal(Integer.getInteger(REST_MAX_CONNECTIONS, 100)).setMaxConnPerRoute(PropertyUtil.propertyAsInt(properties, REST_MAX_CONNECTIONS_PER_ROUTE, 100)).build();
    }

    @VisibleForTesting
    static ConnectionConfig configureConnectionConfig(Map<String, String> properties) {
        Long connectionTimeoutMillis = PropertyUtil.propertyAsNullableLong(properties, REST_CONNECTION_TIMEOUT_MS);
        Integer socketTimeoutMillis = PropertyUtil.propertyAsNullableInt(properties, REST_SOCKET_TIMEOUT_MS);
        if (connectionTimeoutMillis == null && socketTimeoutMillis == null) {
            return null;
        }
        ConnectionConfig.Builder connConfigBuilder = ConnectionConfig.custom();
        if (connectionTimeoutMillis != null) {
            connConfigBuilder.setConnectTimeout(connectionTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        if (socketTimeoutMillis != null) {
            connConfigBuilder.setSocketTimeout(socketTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        return connConfigBuilder.build();
    }

    public static Builder builder(Map<String, String> properties) {
        return new Builder(properties);
    }

    private StringEntity toJson(Object requestBody) {
        try {
            return new StringEntity(this.mapper.writeValueAsString(requestBody), StandardCharsets.UTF_8);
        }
        catch (JsonProcessingException e) {
            throw new RESTException(e, "Failed to write request body: %s", requestBody);
        }
    }

    private StringEntity toFormEncoding(Map<?, ?> formData) {
        return new StringEntity(RESTUtil.encodeFormData(formData), StandardCharsets.UTF_8);
    }

    public static class Builder {
        private final Map<String, String> properties;
        private final Map<String, String> baseHeaders = Maps.newHashMap();
        private String uri;
        private ObjectMapper mapper = RESTObjectMapper.mapper();
        private HttpHost proxy;
        private CredentialsProvider proxyCredentialsProvider;

        private Builder(Map<String, String> properties) {
            this.properties = properties;
        }

        public Builder uri(String path) {
            Preconditions.checkNotNull(path, "Invalid uri for http client: null");
            this.uri = RESTUtil.stripTrailingSlash(path);
            return this;
        }

        public Builder withProxy(String hostname, int port) {
            Preconditions.checkNotNull(hostname, "Invalid hostname for http client proxy: null");
            this.proxy = new HttpHost(hostname, port);
            return this;
        }

        public Builder withProxyCredentialsProvider(CredentialsProvider credentialsProvider) {
            Preconditions.checkNotNull(credentialsProvider, "Invalid credentials provider for http client proxy: null");
            this.proxyCredentialsProvider = credentialsProvider;
            return this;
        }

        public Builder withHeader(String key, String value) {
            this.baseHeaders.put(key, value);
            return this;
        }

        public Builder withHeaders(Map<String, String> headers) {
            this.baseHeaders.putAll(headers);
            return this;
        }

        public Builder withObjectMapper(ObjectMapper objectMapper) {
            this.mapper = objectMapper;
            return this;
        }

        public HTTPClient build() {
            this.withHeader(HTTPClient.CLIENT_VERSION_HEADER, IcebergBuild.fullVersion());
            this.withHeader(HTTPClient.CLIENT_GIT_COMMIT_SHORT_HEADER, IcebergBuild.gitCommitShortId());
            HttpRequestInterceptor interceptor = null;
            if (PropertyUtil.propertyAsBoolean(this.properties, HTTPClient.SIGV4_ENABLED, false)) {
                interceptor = HTTPClient.loadInterceptorDynamically(HTTPClient.SIGV4_REQUEST_INTERCEPTOR_IMPL, this.properties);
            }
            if (this.proxyCredentialsProvider != null) {
                Preconditions.checkNotNull(this.proxy, "Invalid http client proxy for proxy credentials provider: null");
            }
            return new HTTPClient(this.uri, this.proxy, this.proxyCredentialsProvider, this.baseHeaders, this.mapper, interceptor, this.properties, HTTPClient.configureConnectionManager(this.properties));
        }
    }
}

