/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.threeten.extra.chrono;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.chrono.Era;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.shaded.org.threeten.extra.chrono.AbstractNileChronology;
import org.apache.iceberg.shaded.org.threeten.extra.chrono.EthiopicDate;
import org.apache.iceberg.shaded.org.threeten.extra.chrono.EthiopicEra;

public final class EthiopicChronology
extends AbstractNileChronology
implements Serializable {
    public static final EthiopicChronology INSTANCE = new EthiopicChronology();
    private static final long serialVersionUID = 53287687268768L;

    @Deprecated
    public EthiopicChronology() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    @Override
    public String getId() {
        return "Ethiopic";
    }

    @Override
    public String getCalendarType() {
        return "ethiopic";
    }

    @Override
    public EthiopicDate date(Era era, int yearOfEra, int month, int dayOfMonth) {
        return this.date(this.prolepticYear(era, yearOfEra), month, dayOfMonth);
    }

    @Override
    public EthiopicDate date(int prolepticYear, int month, int dayOfMonth) {
        return EthiopicDate.of(prolepticYear, month, dayOfMonth);
    }

    @Override
    public EthiopicDate dateYearDay(Era era, int yearOfEra, int dayOfYear) {
        return this.dateYearDay(this.prolepticYear(era, yearOfEra), dayOfYear);
    }

    @Override
    public EthiopicDate dateYearDay(int prolepticYear, int dayOfYear) {
        return EthiopicDate.ofYearDay(prolepticYear, dayOfYear);
    }

    @Override
    public EthiopicDate dateEpochDay(long epochDay) {
        return EthiopicDate.ofEpochDay(epochDay);
    }

    @Override
    public EthiopicDate dateNow() {
        return EthiopicDate.now();
    }

    @Override
    public EthiopicDate dateNow(ZoneId zone) {
        return EthiopicDate.now(zone);
    }

    @Override
    public EthiopicDate dateNow(Clock clock) {
        return EthiopicDate.now(clock);
    }

    @Override
    public EthiopicDate date(TemporalAccessor temporal) {
        return EthiopicDate.from(temporal);
    }

    public ChronoLocalDateTime<EthiopicDate> localDateTime(TemporalAccessor temporal) {
        return super.localDateTime(temporal);
    }

    public ChronoZonedDateTime<EthiopicDate> zonedDateTime(TemporalAccessor temporal) {
        return super.zonedDateTime(temporal);
    }

    public ChronoZonedDateTime<EthiopicDate> zonedDateTime(Instant instant, ZoneId zone) {
        return super.zonedDateTime(instant, zone);
    }

    @Override
    public int prolepticYear(Era era, int yearOfEra) {
        if (!(era instanceof EthiopicEra)) {
            throw new ClassCastException("Era must be EthiopicEra");
        }
        return era == EthiopicEra.INCARNATION ? yearOfEra : 1 - yearOfEra;
    }

    @Override
    public EthiopicEra eraOf(int eraValue) {
        return EthiopicEra.of(eraValue);
    }

    @Override
    public List<Era> eras() {
        return Arrays.asList(EthiopicEra.values());
    }

    @Override
    public EthiopicDate resolveDate(Map<TemporalField, Long> fieldValues, ResolverStyle resolverStyle) {
        return (EthiopicDate)super.resolveDate(fieldValues, resolverStyle);
    }
}

