/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.error;

import javax.annotation.Nullable;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.immutables.value.Value;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.error.NessieErrorDetails;

@JsonSerialize(as=ImmutableNessieError.class)
@JsonDeserialize(as=ImmutableNessieError.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@Value.Immutable
public interface NessieError {
    public int getStatus();

    public String getReason();

    @Value.Default
    default public String getMessage() {
        return this.getReason();
    }

    @JsonDeserialize(using=ErrorCode.Deserializer.class)
    @Value.Default
    default public ErrorCode getErrorCode() {
        return ErrorCode.UNKNOWN;
    }

    @Nullable
    @jakarta.annotation.Nullable
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public NessieErrorDetails getErrorDetails();

    default public <T extends NessieErrorDetails> T getErrorDetailsAsOrNull(Class<T> type) {
        NessieErrorDetails details = this.getErrorDetails();
        return (T)(details != null && type.isAssignableFrom(details.getClass()) ? (NessieErrorDetails)type.cast(details) : null);
    }

    @Nullable
    @jakarta.annotation.Nullable
    public String getServerStackTrace();

    @JsonIgnore
    @Nullable
    @jakarta.annotation.Nullable
    @Deprecated
    @Value.Auxiliary
    public Exception getClientProcessingException();

    @JsonIgnore
    @Nullable
    @jakarta.annotation.Nullable
    @Value.Auxiliary
    public String getClientProcessingError();

    @JsonIgnore
    default public String getFullMessage() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getReason()).append(" (HTTP/").append(this.getStatus()).append(')');
        sb.append(": ");
        String serverMessage = this.getMessage();
        if (serverMessage == null) {
            serverMessage = "[no error message found in HTTP response]";
        }
        sb.append(serverMessage);
        if (this.getServerStackTrace() != null) {
            sb.append("\n").append(this.getServerStackTrace());
        }
        if (this.getClientProcessingError() != null) {
            sb.append("\nAdditionally, the client-side error below was caught while decoding the HTTP response: ").append(this.getClientProcessingError());
        } else if (this.getClientProcessingException() != null) {
            sb.append("\nAdditionally, the client-side exception below was caught while decoding the HTTP response: ").append(this.getClientProcessingException());
        }
        return sb.toString();
    }
}

