/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.GenericPartitionFieldSummary;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.NaNUtil;

class PartitionSummary {
    private final PartitionFieldStats<?>[] fields;
    private final Class<?>[] javaClasses;

    PartitionSummary(PartitionSpec spec) {
        this.javaClasses = spec.javaClasses();
        this.fields = new PartitionFieldStats[this.javaClasses.length];
        List<Types.NestedField> partitionFields = spec.partitionType().fields();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i] = new PartitionFieldStats(partitionFields.get(i).type());
        }
    }

    List<ManifestFile.PartitionFieldSummary> summaries() {
        return Arrays.stream(this.fields).map(PartitionFieldStats::toSummary).collect(Collectors.toList());
    }

    public void update(StructLike partitionKey) {
        this.updateFields(partitionKey);
    }

    private <T> void updateFields(StructLike key) {
        for (int i = 0; i < this.javaClasses.length; ++i) {
            PartitionFieldStats<?> stats = this.fields[i];
            Class<?> javaClass = this.javaClasses[i];
            stats.update(key.get(i, javaClass));
        }
    }

    private static class PartitionFieldStats<T> {
        private final Type type;
        private final Comparator<T> comparator;
        private boolean containsNull = false;
        private boolean containsNaN = false;
        private T min = null;
        private T max = null;

        private PartitionFieldStats(Type type) {
            this.type = type;
            this.comparator = Comparators.forType(type.asPrimitiveType());
        }

        public ManifestFile.PartitionFieldSummary toSummary() {
            return new GenericPartitionFieldSummary(this.containsNull, this.containsNaN, this.min != null ? Conversions.toByteBuffer(this.type, this.min) : null, this.max != null ? Conversions.toByteBuffer(this.type, this.max) : null);
        }

        void update(T value) {
            if (value == null) {
                this.containsNull = true;
            } else if (NaNUtil.isNaN(value)) {
                this.containsNaN = true;
            } else if (this.min == null) {
                this.min = value;
                this.max = value;
            } else {
                if (this.comparator.compare(value, this.min) < 0) {
                    this.min = value;
                }
                if (this.comparator.compare(this.max, value) < 0) {
                    this.max = value;
                }
            }
        }
    }
}

