/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.deletes.BitmapPositionDeleteIndex;
import org.apache.iceberg.deletes.DeleteCounter;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Comparators;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.CharSequenceMap;
import org.apache.iceberg.util.Filter;
import org.apache.iceberg.util.ParallelIterable;
import org.apache.iceberg.util.SortedMerge;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.iceberg.util.ThreadPools;

public class Deletes {
    private static final Schema POSITION_DELETE_SCHEMA = new Schema(MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS);
    private static final Accessor<StructLike> FILENAME_ACCESSOR = POSITION_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_PATH.fieldId());
    private static final Accessor<StructLike> POSITION_ACCESSOR = POSITION_DELETE_SCHEMA.accessorForField(MetadataColumns.DELETE_FILE_POS.fieldId());

    private Deletes() {
    }

    public static <T> CloseableIterable<T> filter(CloseableIterable<T> rows, Function<T, StructLike> rowToDeleteKey, StructLikeSet deleteSet) {
        if (deleteSet.isEmpty()) {
            return rows;
        }
        EqualitySetDeleteFilter<T> equalityFilter = new EqualitySetDeleteFilter<T>(rowToDeleteKey, deleteSet);
        return equalityFilter.filter(rows);
    }

    public static <T> CloseableIterable<T> markDeleted(CloseableIterable<T> rows, Predicate<T> isDeleted, Consumer<T> deleteMarker) {
        return CloseableIterable.transform(rows, row -> {
            if (isDeleted.test(row)) {
                deleteMarker.accept(row);
            }
            return row;
        });
    }

    public static <T> CloseableIterable<T> filterDeleted(CloseableIterable<T> rows, final Predicate<T> isDeleted, final DeleteCounter counter) {
        Filter remainingRowsFilter = new Filter<T>(){

            @Override
            protected boolean shouldKeep(T item) {
                boolean deleted = isDeleted.test(item);
                if (deleted) {
                    counter.increment();
                }
                return !deleted;
            }
        };
        return remainingRowsFilter.filter(rows);
    }

    public static StructLikeSet toEqualitySet(CloseableIterable<StructLike> eqDeletes, Types.StructType eqType) {
        StructLikeSet structLikeSet;
        block8: {
            CloseableIterable<StructLike> deletes = eqDeletes;
            try {
                StructLikeSet deleteSet = StructLikeSet.create(eqType);
                Iterables.addAll(deleteSet, deletes);
                structLikeSet = deleteSet;
                if (deletes == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (deletes != null) {
                        try {
                            deletes.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to close equality delete source", e);
                }
            }
            deletes.close();
        }
        return structLikeSet;
    }

    public static <T extends StructLike> CharSequenceMap<PositionDeleteIndex> toPositionIndexes(CloseableIterable<T> posDeletes) {
        return Deletes.toPositionIndexes(posDeletes, null);
    }

    public static <T extends StructLike> CharSequenceMap<PositionDeleteIndex> toPositionIndexes(CloseableIterable<T> posDeletes, DeleteFile file) {
        CharSequenceMap<PositionDeleteIndex> indexes = CharSequenceMap.create();
        try (CloseableIterable<T> deletes = posDeletes;){
            for (StructLike delete : deletes) {
                CharSequence filePath = (CharSequence)FILENAME_ACCESSOR.get(delete);
                long position = (Long)POSITION_ACCESSOR.get(delete);
                PositionDeleteIndex index = indexes.computeIfAbsent(filePath, key -> new BitmapPositionDeleteIndex(file));
                index.delete(position);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to close position delete source", e);
        }
        return indexes;
    }

    public static <T extends StructLike> PositionDeleteIndex toPositionIndex(CharSequence dataLocation, CloseableIterable<T> posDeletes, DeleteFile file) {
        CloseableIterable<Long> positions = Deletes.extractPositions(dataLocation, posDeletes);
        ImmutableList<DeleteFile> files = ImmutableList.of(file);
        return Deletes.toPositionIndex(positions, files);
    }

    private static <T extends StructLike> CloseableIterable<Long> extractPositions(CharSequence dataLocation, CloseableIterable<T> rows) {
        DataFileFilter<T> filter = new DataFileFilter<T>(dataLocation);
        CloseableIterable<T> filteredRows = filter.filter(rows);
        return CloseableIterable.transform(filteredRows, row -> (Long)POSITION_ACCESSOR.get((StructLike)row));
    }

    @Deprecated
    public static <T extends StructLike> PositionDeleteIndex toPositionIndex(CharSequence dataLocation, List<CloseableIterable<T>> deleteFiles) {
        return Deletes.toPositionIndex(dataLocation, deleteFiles, ThreadPools.getDeleteWorkerPool());
    }

    @Deprecated
    public static <T extends StructLike> PositionDeleteIndex toPositionIndex(CharSequence dataLocation, List<CloseableIterable<T>> deleteFiles, ExecutorService deleteWorkerPool) {
        DataFileFilter locationFilter = new DataFileFilter(dataLocation);
        List positions = Lists.transform(deleteFiles, deletes -> CloseableIterable.transform(locationFilter.filter(deletes), row -> (Long)POSITION_ACCESSOR.get((StructLike)row)));
        if (positions.size() > 1 && deleteWorkerPool != null) {
            return Deletes.toPositionIndex(new ParallelIterable<Long>(positions, deleteWorkerPool));
        }
        return Deletes.toPositionIndex(CloseableIterable.concat(positions));
    }

    public static PositionDeleteIndex toPositionIndex(CloseableIterable<Long> posDeletes) {
        return Deletes.toPositionIndex(posDeletes, ImmutableList.of());
    }

    private static PositionDeleteIndex toPositionIndex(CloseableIterable<Long> posDeletes, List<DeleteFile> files) {
        BitmapPositionDeleteIndex bitmapPositionDeleteIndex;
        block8: {
            CloseableIterable<Long> deletes = posDeletes;
            try {
                BitmapPositionDeleteIndex positionDeleteIndex = new BitmapPositionDeleteIndex(files);
                deletes.forEach(positionDeleteIndex::delete);
                bitmapPositionDeleteIndex = positionDeleteIndex;
                if (deletes == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (deletes != null) {
                        try {
                            deletes.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException("Failed to close position delete source", e);
                }
            }
            deletes.close();
        }
        return bitmapPositionDeleteIndex;
    }

    @Deprecated
    public static <T> CloseableIterable<T> streamingFilter(CloseableIterable<T> rows, Function<T, Long> rowToPosition, CloseableIterable<Long> posDeletes) {
        return Deletes.streamingFilter(rows, rowToPosition, posDeletes, new DeleteCounter());
    }

    @Deprecated
    public static <T> CloseableIterable<T> streamingFilter(CloseableIterable<T> rows, Function<T, Long> rowToPosition, CloseableIterable<Long> posDeletes, DeleteCounter counter) {
        PositionDeleteIndex positionIndex = Deletes.toPositionIndex(posDeletes);
        Predicate<Object> isDeleted = row -> positionIndex.isDeleted((Long)rowToPosition.apply(row));
        return Deletes.filterDeleted(rows, isDeleted, counter);
    }

    @Deprecated
    public static <T> CloseableIterable<T> streamingMarker(CloseableIterable<T> rows, Function<T, Long> rowToPosition, CloseableIterable<Long> posDeletes, Consumer<T> markRowDeleted) {
        PositionDeleteIndex positionIndex = Deletes.toPositionIndex(posDeletes);
        Predicate<Object> isDeleted = row -> positionIndex.isDeleted((Long)rowToPosition.apply(row));
        return Deletes.markDeleted(rows, isDeleted, markRowDeleted);
    }

    public static CloseableIterable<Long> deletePositions(CharSequence dataLocation, CloseableIterable<StructLike> deleteFile) {
        return Deletes.deletePositions(dataLocation, ImmutableList.of(deleteFile));
    }

    public static <T extends StructLike> CloseableIterable<Long> deletePositions(CharSequence dataLocation, List<CloseableIterable<T>> deleteFiles) {
        DataFileFilter locationFilter = new DataFileFilter(dataLocation);
        List positions = Lists.transform(deleteFiles, deletes -> CloseableIterable.transform(locationFilter.filter(deletes), row -> (Long)POSITION_ACCESSOR.get((StructLike)row)));
        return new SortedMerge<Long>(Long::compare, positions);
    }

    private static class DataFileFilter<T extends StructLike>
    extends Filter<T> {
        private final CharSequence dataLocation;

        DataFileFilter(CharSequence dataLocation) {
            this.dataLocation = dataLocation;
        }

        @Override
        protected boolean shouldKeep(T posDelete) {
            return Comparators.filePath().compare(this.dataLocation, (CharSequence)FILENAME_ACCESSOR.get((StructLike)posDelete)) == 0;
        }
    }

    private static class EqualitySetDeleteFilter<T>
    extends Filter<T> {
        private final StructLikeSet deletes;
        private final Function<T, StructLike> extractEqStruct;

        protected EqualitySetDeleteFilter(Function<T, StructLike> extractEq, StructLikeSet deletes) {
            this.extractEqStruct = extractEq;
            this.deletes = deletes;
        }

        @Override
        protected boolean shouldKeep(T row) {
            return !this.deletes.contains(this.extractEqStruct.apply(row));
        }
    }
}

