/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.deletes;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.function.LongConsumer;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.roaringbitmap.RoaringBitmap;

class RoaringPositionBitmap {
    static final long MAX_POSITION = RoaringPositionBitmap.toPosition(0x7FFFFFFE, Integer.MIN_VALUE);
    private static final RoaringBitmap[] EMPTY_BITMAP_ARRAY = new RoaringBitmap[0];
    private static final long BITMAP_COUNT_SIZE_BYTES = 8L;
    private static final long BITMAP_KEY_SIZE_BYTES = 4L;
    private RoaringBitmap[] bitmaps;

    RoaringPositionBitmap() {
        this.bitmaps = EMPTY_BITMAP_ARRAY;
    }

    private RoaringPositionBitmap(RoaringBitmap[] bitmaps) {
        this.bitmaps = bitmaps;
    }

    public void set(long pos) {
        RoaringPositionBitmap.validatePosition(pos);
        int key = RoaringPositionBitmap.key(pos);
        int pos32Bits = RoaringPositionBitmap.pos32Bits(pos);
        this.allocateBitmapsIfNeeded(key + 1);
        this.bitmaps[key].add(pos32Bits);
    }

    public void setRange(long posStartInclusive, long posEndExclusive) {
        for (long pos = posStartInclusive; pos < posEndExclusive; ++pos) {
            this.set(pos);
        }
    }

    public void setAll(RoaringPositionBitmap that) {
        this.allocateBitmapsIfNeeded(that.bitmaps.length);
        for (int key = 0; key < that.bitmaps.length; ++key) {
            this.bitmaps[key].or(that.bitmaps[key]);
        }
    }

    public boolean contains(long pos) {
        RoaringPositionBitmap.validatePosition(pos);
        int key = RoaringPositionBitmap.key(pos);
        int pos32Bits = RoaringPositionBitmap.pos32Bits(pos);
        return key < this.bitmaps.length && this.bitmaps[key].contains(pos32Bits);
    }

    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    public long cardinality() {
        long cardinality = 0L;
        for (RoaringBitmap bitmap : this.bitmaps) {
            cardinality += bitmap.getLongCardinality();
        }
        return cardinality;
    }

    public boolean runLengthEncode() {
        boolean changed = false;
        for (RoaringBitmap bitmap : this.bitmaps) {
            changed |= bitmap.runOptimize();
        }
        return changed;
    }

    public void forEach(LongConsumer consumer) {
        for (int key = 0; key < this.bitmaps.length; ++key) {
            RoaringPositionBitmap.forEach(key, this.bitmaps[key], consumer);
        }
    }

    @VisibleForTesting
    int allocatedBitmapCount() {
        return this.bitmaps.length;
    }

    private void allocateBitmapsIfNeeded(int requiredLength) {
        if (this.bitmaps.length < requiredLength) {
            if (this.bitmaps.length == 0 && requiredLength == 1) {
                this.bitmaps = new RoaringBitmap[]{new RoaringBitmap()};
            } else {
                RoaringBitmap[] newBitmaps = new RoaringBitmap[requiredLength];
                System.arraycopy(this.bitmaps, 0, newBitmaps, 0, this.bitmaps.length);
                for (int key = this.bitmaps.length; key < requiredLength; ++key) {
                    newBitmaps[key] = new RoaringBitmap();
                }
                this.bitmaps = newBitmaps;
            }
        }
    }

    public long serializedSizeInBytes() {
        long size = 8L;
        for (RoaringBitmap bitmap : this.bitmaps) {
            size += 4L + (long)bitmap.serializedSizeInBytes();
        }
        return size;
    }

    public void serialize(ByteBuffer buffer) {
        RoaringPositionBitmap.validateByteOrder(buffer);
        buffer.putLong(this.bitmaps.length);
        for (int key = 0; key < this.bitmaps.length; ++key) {
            buffer.putInt(key);
            this.bitmaps[key].serialize(buffer);
        }
    }

    public static RoaringPositionBitmap deserialize(ByteBuffer buffer) {
        int remainingBitmapCount;
        RoaringPositionBitmap.validateByteOrder(buffer);
        ArrayList<RoaringBitmap> bitmaps = Lists.newArrayListWithExpectedSize(remainingBitmapCount);
        int lastKey = -1;
        for (remainingBitmapCount = RoaringPositionBitmap.readBitmapCount(buffer); remainingBitmapCount > 0; --remainingBitmapCount) {
            int key = RoaringPositionBitmap.readKey(buffer, lastKey);
            while (lastKey < key - 1) {
                bitmaps.add(new RoaringBitmap());
                ++lastKey;
            }
            RoaringBitmap bitmap = RoaringPositionBitmap.readBitmap(buffer);
            bitmaps.add(bitmap);
            lastKey = key;
        }
        return new RoaringPositionBitmap(bitmaps.toArray(EMPTY_BITMAP_ARRAY));
    }

    private static void validateByteOrder(ByteBuffer buffer) {
        Preconditions.checkArgument(buffer.order() == ByteOrder.LITTLE_ENDIAN, "Roaring bitmap serialization requires little-endian byte order");
    }

    private static int readBitmapCount(ByteBuffer buffer) {
        long bitmapCount = buffer.getLong();
        Preconditions.checkArgument(bitmapCount >= 0L && bitmapCount <= Integer.MAX_VALUE, "Invalid bitmap count: %s", bitmapCount);
        return (int)bitmapCount;
    }

    private static int readKey(ByteBuffer buffer, int lastKey) {
        int key = buffer.getInt();
        Preconditions.checkArgument(key >= 0, "Invalid unsigned key: %s", key);
        Preconditions.checkArgument(key <= 0x7FFFFFFE, "Key is too large: %s", key);
        Preconditions.checkArgument(key > lastKey, "Keys must be sorted in ascending order");
        return key;
    }

    private static RoaringBitmap readBitmap(ByteBuffer buffer) {
        try {
            RoaringBitmap bitmap = new RoaringBitmap();
            bitmap.deserialize(buffer);
            buffer.position(buffer.position() + bitmap.serializedSizeInBytes());
            return bitmap;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static int key(long pos) {
        return (int)(pos >> 32);
    }

    private static int pos32Bits(long pos) {
        return (int)pos;
    }

    private static long toPosition(int key, int pos32Bits) {
        return (long)key << 32 | (long)pos32Bits & 0xFFFFFFFFL;
    }

    private static void forEach(int key, RoaringBitmap bitmap, LongConsumer consumer) {
        bitmap.forEach((int pos32Bits) -> consumer.accept(RoaringPositionBitmap.toPosition(key, pos32Bits)));
    }

    private static void validatePosition(long pos) {
        Preconditions.checkArgument(pos >= 0L && pos <= MAX_POSITION, "Bitmap supports positions that are >= 0 and <= %s: %s", MAX_POSITION, pos);
    }
}

