/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.jdbc.JdbcClientPool;
import org.apache.iceberg.jdbc.UncheckedInterruptedException;
import org.apache.iceberg.jdbc.UncheckedSQLException;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

final class JdbcUtil {
    static final String STRICT_MODE_PROPERTY = "jdbc.strict-mode";
    static final String SCHEMA_VERSION_PROPERTY = "jdbc.schema-version";
    static final String INIT_CATALOG_TABLES_PROPERTY = "jdbc.init-catalog-tables";
    static final String RETRYABLE_STATUS_CODES = "retryable_status_codes";
    static final String CATALOG_TABLE_VIEW_NAME = "iceberg_tables";
    static final String CATALOG_NAME = "catalog_name";
    static final String TABLE_NAME = "table_name";
    static final String TABLE_NAMESPACE = "table_namespace";
    static final String RECORD_TYPE = "iceberg_type";
    static final String TABLE_RECORD_TYPE = "TABLE";
    static final String VIEW_RECORD_TYPE = "VIEW";
    private static final String V1_DO_COMMIT_TABLE_SQL = "UPDATE iceberg_tables SET metadata_location = ? , previous_metadata_location = ? WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? AND metadata_location = ? AND (iceberg_type = 'TABLE' OR iceberg_type IS NULL)";
    private static final String V1_DO_COMMIT_VIEW_SQL = "UPDATE iceberg_tables SET metadata_location = ? , previous_metadata_location = ? WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? AND metadata_location = ? AND iceberg_type = 'VIEW'";
    private static final String V0_DO_COMMIT_SQL = "UPDATE iceberg_tables SET metadata_location = ? , previous_metadata_location = ? WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? AND metadata_location = ?";
    static final String V0_CREATE_CATALOG_SQL = "CREATE TABLE iceberg_tables(catalog_name VARCHAR(255) NOT NULL,table_namespace VARCHAR(255) NOT NULL,table_name VARCHAR(255) NOT NULL,metadata_location VARCHAR(1000),previous_metadata_location VARCHAR(1000),PRIMARY KEY (catalog_name, table_namespace, table_name))";
    static final String V1_UPDATE_CATALOG_SQL = "ALTER TABLE iceberg_tables ADD COLUMN iceberg_type VARCHAR(5)";
    private static final String GET_VIEW_SQL = "SELECT * FROM iceberg_tables WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? AND iceberg_type = 'VIEW'";
    private static final String V1_GET_TABLE_SQL = "SELECT * FROM iceberg_tables WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? AND (iceberg_type = 'TABLE' OR iceberg_type IS NULL)";
    private static final String V0_GET_TABLE_SQL = "SELECT * FROM iceberg_tables WHERE catalog_name = ? AND table_namespace = ? AND table_name = ?";
    static final String LIST_VIEW_SQL = "SELECT * FROM iceberg_tables WHERE catalog_name = ? AND table_namespace = ? AND iceberg_type = 'VIEW'";
    static final String V1_LIST_TABLE_SQL = "SELECT * FROM iceberg_tables WHERE catalog_name = ? AND table_namespace = ? AND (iceberg_type = 'TABLE' OR iceberg_type IS NULL)";
    static final String V0_LIST_TABLE_SQL = "SELECT * FROM iceberg_tables WHERE catalog_name = ? AND table_namespace = ?";
    static final String RENAME_VIEW_SQL = "UPDATE iceberg_tables SET table_namespace = ?, table_name = ? WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? AND iceberg_type = 'VIEW'";
    static final String V1_RENAME_TABLE_SQL = "UPDATE iceberg_tables SET table_namespace = ?, table_name = ? WHERE catalog_name = ? AND table_namespace = ? AND table_name = ? AND (iceberg_type = 'TABLE' OR iceberg_type IS NULL)";
    static final String V0_RENAME_TABLE_SQL = "UPDATE iceberg_tables SET table_namespace = ?, table_name = ? WHERE catalog_name = ? AND table_namespace = ? AND table_name = ?";
    static final String DROP_VIEW_SQL = "DELETE FROM iceberg_tables WHERE catalog_name = ? AND table_namespace  = ? AND table_name = ? AND iceberg_type = 'VIEW'";
    static final String V1_DROP_TABLE_SQL = "DELETE FROM iceberg_tables WHERE catalog_name = ? AND table_namespace  = ? AND table_name = ? AND (iceberg_type = 'TABLE' OR iceberg_type IS NULL)";
    static final String V0_DROP_TABLE_SQL = "DELETE FROM iceberg_tables WHERE catalog_name = ? AND table_namespace  = ? AND table_name = ?";
    private static final String GET_NAMESPACE_SQL = "SELECT table_namespace FROM iceberg_tables WHERE catalog_name = ? AND  (table_namespace = ? OR table_namespace LIKE ? ESCAPE '!') LIMIT 1";
    static final String LIST_NAMESPACES_SQL = "SELECT DISTINCT table_namespace FROM iceberg_tables WHERE catalog_name = ? AND table_namespace LIKE ?";
    static final String LIST_ALL_NAMESPACES_SQL = "SELECT DISTINCT table_namespace FROM iceberg_tables WHERE catalog_name = ?";
    private static final String V1_DO_COMMIT_CREATE_SQL = "INSERT INTO iceberg_tables (catalog_name, table_namespace, table_name, metadata_location, previous_metadata_location, iceberg_type)  VALUES (?,?,?,?,null,?)";
    private static final String V0_DO_COMMIT_CREATE_SQL = "INSERT INTO iceberg_tables (catalog_name, table_namespace, table_name, metadata_location, previous_metadata_location)  VALUES (?,?,?,?,null)";
    static final String NAMESPACE_PROPERTIES_TABLE_NAME = "iceberg_namespace_properties";
    static final String NAMESPACE_NAME = "namespace";
    static final String NAMESPACE_PROPERTY_KEY = "property_key";
    static final String NAMESPACE_PROPERTY_VALUE = "property_value";
    static final String CREATE_NAMESPACE_PROPERTIES_TABLE_SQL = "CREATE TABLE iceberg_namespace_properties(catalog_name VARCHAR(255) NOT NULL,namespace VARCHAR(255) NOT NULL,property_key VARCHAR(255),property_value VARCHAR(1000),PRIMARY KEY (catalog_name, namespace, property_key))";
    static final String GET_NAMESPACE_PROPERTIES_SQL = "SELECT namespace FROM iceberg_namespace_properties WHERE catalog_name = ? AND  ( namespace = ? OR namespace LIKE ? ESCAPE '!'  ) ";
    static final String INSERT_NAMESPACE_PROPERTIES_SQL = "INSERT INTO iceberg_namespace_properties (catalog_name, namespace, property_key, property_value) VALUES ";
    static final String INSERT_PROPERTIES_VALUES_BASE = "(?,?,?,?)";
    static final String GET_ALL_NAMESPACE_PROPERTIES_SQL = "SELECT *  FROM iceberg_namespace_properties WHERE catalog_name = ? AND namespace = ? ";
    static final String DELETE_NAMESPACE_PROPERTIES_SQL = "DELETE FROM iceberg_namespace_properties WHERE catalog_name = ? AND namespace = ? AND property_key IN ";
    static final String DELETE_ALL_NAMESPACE_PROPERTIES_SQL = "DELETE FROM iceberg_namespace_properties WHERE catalog_name = ? AND namespace = ?";
    static final String LIST_PROPERTY_NAMESPACES_SQL = "SELECT DISTINCT namespace FROM iceberg_namespace_properties WHERE catalog_name = ? AND namespace LIKE ?";
    static final String LIST_ALL_PROPERTY_NAMESPACES_SQL = "SELECT DISTINCT namespace FROM iceberg_namespace_properties WHERE catalog_name = ?";
    private static final Joiner JOINER_DOT = Joiner.on('.');
    private static final Splitter SPLITTER_DOT = Splitter.on('.');

    private JdbcUtil() {
    }

    static Namespace stringToNamespace(String namespace) {
        Preconditions.checkArgument(namespace != null, "Invalid namespace %s", (Object)namespace);
        return Namespace.of(Iterables.toArray(SPLITTER_DOT.split(namespace), String.class));
    }

    static String namespaceToString(Namespace namespace) {
        return JOINER_DOT.join(namespace.levels());
    }

    static TableIdentifier stringToTableIdentifier(String tableNamespace, String tableName) {
        return TableIdentifier.of(JdbcUtil.stringToNamespace(tableNamespace), tableName);
    }

    static Properties filterAndRemovePrefix(Map<String, String> properties, String prefix) {
        Properties result = new Properties();
        properties.forEach((key, value) -> {
            if (key.startsWith(prefix)) {
                result.put(key.substring(prefix.length()), value);
            }
        });
        return result;
    }

    private static int update(boolean isTable, SchemaVersion schemaVersion, JdbcClientPool connections, String catalogName, TableIdentifier identifier, String newMetadataLocation, String oldMetadataLocation) throws SQLException, InterruptedException {
        return connections.run(conn -> {
            try (PreparedStatement sql = conn.prepareStatement(schemaVersion == SchemaVersion.V1 ? (isTable ? V1_DO_COMMIT_TABLE_SQL : V1_DO_COMMIT_VIEW_SQL) : V0_DO_COMMIT_SQL);){
                sql.setString(1, newMetadataLocation);
                sql.setString(2, oldMetadataLocation);
                sql.setString(3, catalogName);
                sql.setString(4, JdbcUtil.namespaceToString(identifier.namespace()));
                sql.setString(5, identifier.name());
                sql.setString(6, oldMetadataLocation);
                Integer n = sql.executeUpdate();
                return n;
            }
        });
    }

    static int updateTable(SchemaVersion schemaVersion, JdbcClientPool connections, String catalogName, TableIdentifier tableIdentifier, String newMetadataLocation, String oldMetadataLocation) throws SQLException, InterruptedException {
        return JdbcUtil.update(true, schemaVersion, connections, catalogName, tableIdentifier, newMetadataLocation, oldMetadataLocation);
    }

    static int updateView(JdbcClientPool connections, String catalogName, TableIdentifier viewIdentifier, String newMetadataLocation, String oldMetadataLocation) throws SQLException, InterruptedException {
        return JdbcUtil.update(false, SchemaVersion.V1, connections, catalogName, viewIdentifier, newMetadataLocation, oldMetadataLocation);
    }

    private static Map<String, String> tableOrView(boolean isTable, SchemaVersion schemaVersion, JdbcClientPool connections, String catalogName, TableIdentifier identifier) throws SQLException, InterruptedException {
        return connections.run(conn -> {
            HashMap<String, String> tableOrView = Maps.newHashMap();
            try (PreparedStatement sql = conn.prepareStatement(isTable ? (schemaVersion == SchemaVersion.V1 ? V1_GET_TABLE_SQL : V0_GET_TABLE_SQL) : GET_VIEW_SQL);){
                sql.setString(1, catalogName);
                sql.setString(2, JdbcUtil.namespaceToString(identifier.namespace()));
                sql.setString(3, identifier.name());
                ResultSet rs = sql.executeQuery();
                if (rs.next()) {
                    tableOrView.put(CATALOG_NAME, rs.getString(CATALOG_NAME));
                    tableOrView.put(TABLE_NAMESPACE, rs.getString(TABLE_NAMESPACE));
                    tableOrView.put(TABLE_NAME, rs.getString(TABLE_NAME));
                    tableOrView.put("metadata_location", rs.getString("metadata_location"));
                    tableOrView.put("previous_metadata_location", rs.getString("previous_metadata_location"));
                }
                rs.close();
            }
            return tableOrView;
        });
    }

    static Map<String, String> loadTable(SchemaVersion schemaVersion, JdbcClientPool connections, String catalogName, TableIdentifier identifier) throws SQLException, InterruptedException {
        return JdbcUtil.tableOrView(true, schemaVersion, connections, catalogName, identifier);
    }

    static Map<String, String> loadView(SchemaVersion schemaVersion, JdbcClientPool connections, String catalogName, TableIdentifier identifier) throws SQLException, InterruptedException {
        return JdbcUtil.tableOrView(false, schemaVersion, connections, catalogName, identifier);
    }

    private static int doCommitCreate(boolean isTable, SchemaVersion schemaVersion, JdbcClientPool connections, String catalogName, Namespace namespace, TableIdentifier identifier, String newMetadataLocation) throws SQLException, InterruptedException {
        return connections.run(conn -> {
            try (PreparedStatement sql = conn.prepareStatement(schemaVersion == SchemaVersion.V1 ? V1_DO_COMMIT_CREATE_SQL : V0_DO_COMMIT_CREATE_SQL);){
                sql.setString(1, catalogName);
                sql.setString(2, JdbcUtil.namespaceToString(namespace));
                sql.setString(3, identifier.name());
                sql.setString(4, newMetadataLocation);
                if (schemaVersion == SchemaVersion.V1) {
                    sql.setString(5, isTable ? TABLE_RECORD_TYPE : VIEW_RECORD_TYPE);
                }
                Integer n = sql.executeUpdate();
                return n;
            }
        });
    }

    static int doCommitCreateTable(SchemaVersion schemaVersion, JdbcClientPool connections, String catalogName, Namespace namespace, TableIdentifier tableIdentifier, String newMetadataLocation) throws SQLException, InterruptedException {
        return JdbcUtil.doCommitCreate(true, schemaVersion, connections, catalogName, namespace, tableIdentifier, newMetadataLocation);
    }

    static int doCommitCreateView(JdbcClientPool connections, String catalogName, Namespace namespace, TableIdentifier viewIdentifier, String newMetadataLocation) throws SQLException, InterruptedException {
        return JdbcUtil.doCommitCreate(false, SchemaVersion.V1, connections, catalogName, namespace, viewIdentifier, newMetadataLocation);
    }

    static boolean viewExists(String catalogName, JdbcClientPool connections, TableIdentifier viewIdentifier) {
        return JdbcUtil.exists(connections, GET_VIEW_SQL, catalogName, JdbcUtil.namespaceToString(viewIdentifier.namespace()), viewIdentifier.name());
    }

    static boolean tableExists(SchemaVersion schemaVersion, String catalogName, JdbcClientPool connections, TableIdentifier tableIdentifier) {
        return JdbcUtil.exists(connections, schemaVersion == SchemaVersion.V1 ? V1_GET_TABLE_SQL : V0_GET_TABLE_SQL, catalogName, JdbcUtil.namespaceToString(tableIdentifier.namespace()), tableIdentifier.name());
    }

    static String updatePropertiesStatement(int size) {
        StringBuilder sqlStatement = new StringBuilder("UPDATE iceberg_namespace_properties SET property_value = CASE");
        for (int i = 0; i < size; ++i) {
            sqlStatement.append(" WHEN property_key = ? THEN ?");
        }
        sqlStatement.append(" END WHERE catalog_name = ? AND namespace = ? AND property_key IN ");
        String values = String.join((CharSequence)",", Collections.nCopies(size, String.valueOf('?')));
        sqlStatement.append("(").append(values).append(")");
        return sqlStatement.toString();
    }

    static String insertPropertiesStatement(int size) {
        StringBuilder sqlStatement = new StringBuilder(INSERT_NAMESPACE_PROPERTIES_SQL);
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sqlStatement.append(", ");
            }
            sqlStatement.append(INSERT_PROPERTIES_VALUES_BASE);
        }
        return sqlStatement.toString();
    }

    static String deletePropertiesStatement(Set<String> properties) {
        StringBuilder sqlStatement = new StringBuilder(DELETE_NAMESPACE_PROPERTIES_SQL);
        String values = String.join((CharSequence)",", Collections.nCopies(properties.size(), String.valueOf('?')));
        sqlStatement.append("(").append(values).append(")");
        return sqlStatement.toString();
    }

    static boolean namespaceExists(String catalogName, JdbcClientPool connections, Namespace namespace) {
        String namespaceEquals = JdbcUtil.namespaceToString(namespace);
        String namespaceStartsWith = namespaceEquals.replace("!", "!!").replace("_", "!_").replace("%", "!%") + ".%";
        if (JdbcUtil.exists(connections, GET_NAMESPACE_SQL, catalogName, namespaceEquals, namespaceStartsWith)) {
            return true;
        }
        return JdbcUtil.exists(connections, GET_NAMESPACE_PROPERTIES_SQL, catalogName, namespaceEquals, namespaceStartsWith);
    }

    private static boolean exists(JdbcClientPool connections, String sql, String ... args) {
        try {
            return connections.run(conn -> {
                try (PreparedStatement preparedStatement = conn.prepareStatement(sql);){
                    for (int pos = 0; pos < args.length; ++pos) {
                        preparedStatement.setString(pos + 1, args[pos]);
                    }
                    try (ResultSet rs = preparedStatement.executeQuery();){
                        if (rs.next()) {
                            Boolean bl = true;
                            return bl;
                        }
                    }
                }
                return false;
            });
        }
        catch (SQLException e) {
            throw new UncheckedSQLException(e, "Failed to execute exists query: %s", sql);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new UncheckedInterruptedException(e, "Interrupted in SQL query", new Object[0]);
        }
    }

    static enum SchemaVersion {
        V0,
        V1;

    }
}

