/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.vector;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.mr.hive.vector.CompatibilityHiveVectorUtils;

public final class VectorizedRowBatchIterator
implements CloseableIterator<VectorizedRowBatch> {
    private final RecordReader<NullWritable, VectorizedRowBatch> recordReader;
    private final NullWritable key;
    private final VectorizedRowBatch batch;
    private final VectorizedRowBatchCtx vrbCtx;
    private final int[] partitionColIndices;
    private final Object[] partitionValues;
    private boolean advanced = false;

    VectorizedRowBatchIterator(RecordReader<NullWritable, VectorizedRowBatch> recordReader, JobConf job, int[] partitionColIndices, Object[] partitionValues) {
        this.recordReader = recordReader;
        this.key = (NullWritable)recordReader.createKey();
        this.batch = (VectorizedRowBatch)recordReader.createValue();
        this.vrbCtx = CompatibilityHiveVectorUtils.findMapWork(job).getVectorizedRowBatchCtx();
        this.partitionColIndices = partitionColIndices;
        this.partitionValues = partitionValues;
    }

    @Override
    public void close() throws IOException {
        this.recordReader.close();
    }

    private void advance() {
        if (!this.advanced) {
            try {
                if (!this.recordReader.next((Object)this.key, (Object)this.batch)) {
                    this.batch.size = 0;
                }
                if (this.partitionColIndices != null) {
                    for (int i = 0; i < this.partitionColIndices.length; ++i) {
                        int colIdx = this.partitionColIndices[i];
                        CompatibilityHiveVectorUtils.addPartitionColsToBatch(this.batch.cols[colIdx], this.partitionValues[i], this.vrbCtx.getRowColumnNames()[colIdx], this.vrbCtx.getRowColumnTypeInfos()[colIdx]);
                    }
                }
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            this.advanced = true;
        }
    }

    @Override
    public boolean hasNext() {
        this.advance();
        return this.batch.size > 0;
    }

    @Override
    public VectorizedRowBatch next() {
        this.advance();
        this.advanced = false;
        return this.batch;
    }
}

