/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.relocated.com.google.common.base.Supplier;
import org.apache.iceberg.shaded.org.apache.hc.core5.http.Method;

public class Endpoint {
    public static final Endpoint V1_LIST_NAMESPACES = Endpoint.create("GET", "/v1/{prefix}/namespaces");
    public static final Endpoint V1_LOAD_NAMESPACE = Endpoint.create("GET", "/v1/{prefix}/namespaces/{namespace}");
    public static final Endpoint V1_CREATE_NAMESPACE = Endpoint.create("POST", "/v1/{prefix}/namespaces");
    public static final Endpoint V1_UPDATE_NAMESPACE = Endpoint.create("POST", "/v1/{prefix}/namespaces/{namespace}/properties");
    public static final Endpoint V1_DELETE_NAMESPACE = Endpoint.create("DELETE", "/v1/{prefix}/namespaces/{namespace}");
    public static final Endpoint V1_COMMIT_TRANSACTION = Endpoint.create("POST", "/v1/{prefix}/transactions/commit");
    public static final Endpoint V1_LIST_TABLES = Endpoint.create("GET", "/v1/{prefix}/namespaces/{namespace}/tables");
    public static final Endpoint V1_LOAD_TABLE = Endpoint.create("GET", "/v1/{prefix}/namespaces/{namespace}/tables/{table}");
    public static final Endpoint V1_CREATE_TABLE = Endpoint.create("POST", "/v1/{prefix}/namespaces/{namespace}/tables");
    public static final Endpoint V1_UPDATE_TABLE = Endpoint.create("POST", "/v1/{prefix}/namespaces/{namespace}/tables/{table}");
    public static final Endpoint V1_DELETE_TABLE = Endpoint.create("DELETE", "/v1/{prefix}/namespaces/{namespace}/tables/{table}");
    public static final Endpoint V1_RENAME_TABLE = Endpoint.create("POST", "/v1/{prefix}/tables/rename");
    public static final Endpoint V1_REGISTER_TABLE = Endpoint.create("POST", "/v1/{prefix}/namespaces/{namespace}/register");
    public static final Endpoint V1_REPORT_METRICS = Endpoint.create("POST", "/v1/{prefix}/namespaces/{namespace}/tables/{table}/metrics");
    public static final Endpoint V1_LIST_VIEWS = Endpoint.create("GET", "/v1/{prefix}/namespaces/{namespace}/views");
    public static final Endpoint V1_LOAD_VIEW = Endpoint.create("GET", "/v1/{prefix}/namespaces/{namespace}/views/{view}");
    public static final Endpoint V1_CREATE_VIEW = Endpoint.create("POST", "/v1/{prefix}/namespaces/{namespace}/views");
    public static final Endpoint V1_UPDATE_VIEW = Endpoint.create("POST", "/v1/{prefix}/namespaces/{namespace}/views/{view}");
    public static final Endpoint V1_DELETE_VIEW = Endpoint.create("DELETE", "/v1/{prefix}/namespaces/{namespace}/views/{view}");
    public static final Endpoint V1_RENAME_VIEW = Endpoint.create("POST", "/v1/{prefix}/views/rename");
    private static final Splitter ENDPOINT_SPLITTER = Splitter.on(" ");
    private static final Joiner ENDPOINT_JOINER = Joiner.on(" ");
    private final String httpMethod;
    private final String path;

    private Endpoint(String httpMethod, String path) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(httpMethod), "Invalid HTTP method: null or empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(path), "Invalid path: null or empty");
        this.httpMethod = Method.normalizedValueOf(httpMethod).toString();
        this.path = path;
    }

    public String httpMethod() {
        return this.httpMethod;
    }

    public String path() {
        return this.path;
    }

    public static Endpoint create(String httpMethod, String path) {
        return new Endpoint(httpMethod, path);
    }

    public String toString() {
        return ENDPOINT_JOINER.join(this.httpMethod(), this.path(), new Object[0]);
    }

    public static Endpoint fromString(String endpoint) {
        List<String> elements = ENDPOINT_SPLITTER.splitToList(endpoint);
        Preconditions.checkArgument(elements.size() == 2, "Invalid endpoint (must consist of two elements separated by a single space): %s", (Object)endpoint);
        return Endpoint.create(elements.get(0), elements.get(1));
    }

    public static void check(Set<Endpoint> supportedEndpoints, Endpoint endpoint) {
        if (!supportedEndpoints.contains(endpoint)) {
            throw new UnsupportedOperationException(String.format("Server does not support endpoint: %s", endpoint));
        }
    }

    public static void check(Set<Endpoint> supportedEndpoints, Endpoint endpoint, Supplier<RuntimeException> supplier) {
        if (!supportedEndpoints.contains(endpoint)) {
            throw supplier.get();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Endpoint)) {
            return false;
        }
        Endpoint endpoint = (Endpoint)o;
        return Objects.equals(this.httpMethod, endpoint.httpMethod) && Objects.equals(this.path, endpoint.path);
    }

    public int hashCode() {
        return Objects.hash(this.httpMethod, this.path);
    }
}

