/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata;

import java.util.Set;
import org.apache.iceberg.shaded.org.apache.parquet.column.Encoding;
import org.apache.iceberg.shaded.org.apache.parquet.column.EncodingStats;
import org.apache.iceberg.shaded.org.apache.parquet.column.statistics.Statistics;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnChunkProperties;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.iceberg.shaded.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;

class IntColumnChunkMetaData
extends ColumnChunkMetaData {
    private final int firstDataPage;
    private final int dictionaryPageOffset;
    private final int valueCount;
    private final int totalSize;
    private final int totalUncompressedSize;
    private final Statistics statistics;

    IntColumnChunkMetaData(ColumnPath path, PrimitiveType type, CompressionCodecName codec, EncodingStats encodingStats, Set<Encoding> encodings, Statistics statistics, long firstDataPage, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        super(encodingStats, ColumnChunkProperties.get(path, type, codec, encodings));
        this.firstDataPage = this.positiveLongToInt(firstDataPage);
        this.dictionaryPageOffset = this.positiveLongToInt(dictionaryPageOffset);
        this.valueCount = this.positiveLongToInt(valueCount);
        this.totalSize = this.positiveLongToInt(totalSize);
        this.totalUncompressedSize = this.positiveLongToInt(totalUncompressedSize);
        this.statistics = statistics;
    }

    private int positiveLongToInt(long value) {
        if (!ColumnChunkMetaData.positiveLongFitsInAnInt(value)) {
            throw new IllegalArgumentException("value should be positive and fit in an int: " + value);
        }
        return (int)(value + Integer.MIN_VALUE);
    }

    private long intToPositiveLong(int value) {
        return (long)value - Integer.MIN_VALUE;
    }

    @Override
    public long getFirstDataPageOffset() {
        return this.intToPositiveLong(this.firstDataPage);
    }

    @Override
    public long getDictionaryPageOffset() {
        return this.intToPositiveLong(this.dictionaryPageOffset);
    }

    @Override
    public long getValueCount() {
        return this.intToPositiveLong(this.valueCount);
    }

    @Override
    public long getTotalUncompressedSize() {
        return this.intToPositiveLong(this.totalUncompressedSize);
    }

    @Override
    public long getTotalSize() {
        return this.intToPositiveLong(this.totalSize);
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }
}

