/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.iceberg.shaded.com.fasterxml.jackson.annotation.JsonTypeInfo;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.ClientCredentialsTokenRequest;
import org.projectnessie.client.auth.oauth2.GrantType;
import org.projectnessie.client.auth.oauth2.TokenRequestBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClientCredentialsTokenRequest", generator="Immutables")
@Immutable
final class ImmutableClientCredentialsTokenRequest
implements ClientCredentialsTokenRequest {
    @Nullable
    private final String scope;
    private final transient GrantType grantType;

    private ImmutableClientCredentialsTokenRequest(@Nullable String scope) {
        this.scope = scope;
        this.grantType = Objects.requireNonNull(ClientCredentialsTokenRequest.super.getGrantType(), "grantType");
    }

    @Override
    @JsonProperty(value="scope")
    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Override
    @JsonProperty(value="grantType")
    public GrantType getGrantType() {
        return this.grantType;
    }

    public final ImmutableClientCredentialsTokenRequest withScope(@Nullable String value) {
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new ImmutableClientCredentialsTokenRequest(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClientCredentialsTokenRequest && this.equalTo(0, (ImmutableClientCredentialsTokenRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableClientCredentialsTokenRequest another) {
        return Objects.equals(this.scope, another.scope) && this.grantType.equals((Object)another.grantType);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.scope);
        h2 += (h2 << 5) + this.grantType.hashCode();
        return h2;
    }

    public String toString() {
        return "ClientCredentialsTokenRequest{scope=" + this.scope + ", grantType=" + String.valueOf((Object)this.grantType) + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableClientCredentialsTokenRequest fromJson(Json json) {
        Builder builder = ImmutableClientCredentialsTokenRequest.builder();
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        return builder.build();
    }

    public static ImmutableClientCredentialsTokenRequest copyOf(ClientCredentialsTokenRequest instance) {
        if (instance instanceof ImmutableClientCredentialsTokenRequest) {
            return (ImmutableClientCredentialsTokenRequest)instance;
        }
        return ImmutableClientCredentialsTokenRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClientCredentialsTokenRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements ClientCredentialsTokenRequest.Builder {
        @Nullable
        private String scope;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ClientCredentialsTokenRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenRequestBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String scopeValue;
            TokenRequestBase instance;
            long bits = 0L;
            if (object instanceof ClientCredentialsTokenRequest) {
                instance = (ClientCredentialsTokenRequest)object;
                if ((bits & 1L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof TokenRequestBase) {
                instance = (TokenRequestBase)object;
                if ((bits & 1L) == 0L) {
                    scopeValue = instance.getScope();
                    if (scopeValue != null) {
                        this.scope(scopeValue);
                    }
                    bits |= 1L;
                }
            }
        }

        @JsonProperty(value="scope")
        @CanIgnoreReturnValue
        public final Builder scope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public ImmutableClientCredentialsTokenRequest build() {
            return new ImmutableClientCredentialsTokenRequest(this.scope);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ClientCredentialsTokenRequest", generator="Immutables")
    static final class Json
    implements ClientCredentialsTokenRequest {
        @Nullable
        String scope;

        Json() {
        }

        @JsonProperty(value="scope")
        public void setScope(@Nullable String scope) {
            this.scope = scope;
        }

        @Override
        public String getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public GrantType getGrantType() {
            throw new UnsupportedOperationException();
        }
    }
}

