/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth.oauth2;

import java.net.URI;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;
import org.projectnessie.client.auth.oauth2.AccessToken;
import org.projectnessie.client.auth.oauth2.RefreshToken;
import org.projectnessie.client.auth.oauth2.TokenExchangeConfig;
import org.projectnessie.client.auth.oauth2.TypedToken;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TokenExchangeConfig", generator="Immutables")
@Immutable
public final class ImmutableTokenExchangeConfig
implements TokenExchangeConfig {
    private final URI requestedTokenType;
    @Nullable
    private final URI resource;
    @Nullable
    private final String audience;
    private final BiFunction<AccessToken, RefreshToken, TypedToken> subjectTokenProvider;
    private final BiFunction<AccessToken, RefreshToken, TypedToken> actorTokenProvider;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTokenExchangeConfig(Builder builder) {
        this.resource = builder.resource;
        this.audience = builder.audience;
        if (builder.requestedTokenType != null) {
            this.initShim.requestedTokenType(builder.requestedTokenType);
        }
        if (builder.subjectTokenProvider != null) {
            this.initShim.subjectTokenProvider(builder.subjectTokenProvider);
        }
        if (builder.actorTokenProvider != null) {
            this.initShim.actorTokenProvider(builder.actorTokenProvider);
        }
        this.requestedTokenType = this.initShim.getRequestedTokenType();
        this.subjectTokenProvider = this.initShim.getSubjectTokenProvider();
        this.actorTokenProvider = this.initShim.getActorTokenProvider();
        this.initShim = null;
    }

    private ImmutableTokenExchangeConfig(URI requestedTokenType, @Nullable URI resource, @Nullable String audience, BiFunction<AccessToken, RefreshToken, TypedToken> subjectTokenProvider, BiFunction<AccessToken, RefreshToken, TypedToken> actorTokenProvider) {
        this.requestedTokenType = requestedTokenType;
        this.resource = resource;
        this.audience = audience;
        this.subjectTokenProvider = subjectTokenProvider;
        this.actorTokenProvider = actorTokenProvider;
        this.initShim = null;
    }

    private URI getRequestedTokenTypeInitialize() {
        return TokenExchangeConfig.super.getRequestedTokenType();
    }

    private BiFunction<AccessToken, RefreshToken, TypedToken> getSubjectTokenProviderInitialize() {
        return TokenExchangeConfig.super.getSubjectTokenProvider();
    }

    private BiFunction<AccessToken, RefreshToken, TypedToken> getActorTokenProviderInitialize() {
        return TokenExchangeConfig.super.getActorTokenProvider();
    }

    @Override
    public URI getRequestedTokenType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getRequestedTokenType() : this.requestedTokenType;
    }

    @Override
    public Optional<URI> getResource() {
        return Optional.ofNullable(this.resource);
    }

    @Override
    public Optional<String> getAudience() {
        return Optional.ofNullable(this.audience);
    }

    @Override
    public BiFunction<AccessToken, RefreshToken, TypedToken> getSubjectTokenProvider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSubjectTokenProvider() : this.subjectTokenProvider;
    }

    @Override
    public BiFunction<AccessToken, RefreshToken, TypedToken> getActorTokenProvider() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getActorTokenProvider() : this.actorTokenProvider;
    }

    public final ImmutableTokenExchangeConfig withRequestedTokenType(URI value) {
        if (this.requestedTokenType == value) {
            return this;
        }
        URI newValue = Objects.requireNonNull(value, "requestedTokenType");
        return new ImmutableTokenExchangeConfig(newValue, this.resource, this.audience, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withResource(URI value) {
        URI newValue = Objects.requireNonNull(value, "resource");
        if (this.resource == newValue) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.requestedTokenType, newValue, this.audience, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withResource(Optional<? extends URI> optional) {
        URI value = optional.orElse(null);
        if (this.resource == value) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.requestedTokenType, value, this.audience, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withAudience(String value) {
        String newValue = Objects.requireNonNull(value, "audience");
        if (Objects.equals(this.audience, newValue)) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.requestedTokenType, this.resource, newValue, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withAudience(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.audience, value)) {
            return this;
        }
        return new ImmutableTokenExchangeConfig(this.requestedTokenType, this.resource, value, this.subjectTokenProvider, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withSubjectTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> value) {
        if (this.subjectTokenProvider == value) {
            return this;
        }
        BiFunction<AccessToken, RefreshToken, TypedToken> newValue = Objects.requireNonNull(value, "subjectTokenProvider");
        return new ImmutableTokenExchangeConfig(this.requestedTokenType, this.resource, this.audience, newValue, this.actorTokenProvider);
    }

    public final ImmutableTokenExchangeConfig withActorTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> value) {
        if (this.actorTokenProvider == value) {
            return this;
        }
        BiFunction<AccessToken, RefreshToken, TypedToken> newValue = Objects.requireNonNull(value, "actorTokenProvider");
        return new ImmutableTokenExchangeConfig(this.requestedTokenType, this.resource, this.audience, this.subjectTokenProvider, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTokenExchangeConfig && this.equalTo(0, (ImmutableTokenExchangeConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableTokenExchangeConfig another) {
        return this.requestedTokenType.equals(another.requestedTokenType) && Objects.equals(this.resource, another.resource) && Objects.equals(this.audience, another.audience);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.requestedTokenType.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.resource);
        h2 += (h2 << 5) + Objects.hashCode(this.audience);
        return h2;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("TokenExchangeConfig{");
        builder.append("requestedTokenType=").append(this.requestedTokenType);
        if (this.resource != null) {
            builder.append(", ");
            builder.append("resource=").append(this.resource);
        }
        if (this.audience != null) {
            builder.append(", ");
            builder.append("audience=").append(this.audience);
        }
        return builder.append("}").toString();
    }

    public static ImmutableTokenExchangeConfig copyOf(TokenExchangeConfig instance) {
        if (instance instanceof ImmutableTokenExchangeConfig) {
            return (ImmutableTokenExchangeConfig)instance;
        }
        return ImmutableTokenExchangeConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TokenExchangeConfig", generator="Immutables")
    private final class InitShim {
        private byte requestedTokenTypeBuildStage = 0;
        private URI requestedTokenType;
        private byte subjectTokenProviderBuildStage = 0;
        private BiFunction<AccessToken, RefreshToken, TypedToken> subjectTokenProvider;
        private byte actorTokenProviderBuildStage = 0;
        private BiFunction<AccessToken, RefreshToken, TypedToken> actorTokenProvider;

        private InitShim() {
        }

        URI getRequestedTokenType() {
            if (this.requestedTokenTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.requestedTokenTypeBuildStage == 0) {
                this.requestedTokenTypeBuildStage = (byte)-1;
                this.requestedTokenType = Objects.requireNonNull(ImmutableTokenExchangeConfig.this.getRequestedTokenTypeInitialize(), "requestedTokenType");
                this.requestedTokenTypeBuildStage = 1;
            }
            return this.requestedTokenType;
        }

        void requestedTokenType(URI requestedTokenType) {
            this.requestedTokenType = requestedTokenType;
            this.requestedTokenTypeBuildStage = 1;
        }

        BiFunction<AccessToken, RefreshToken, TypedToken> getSubjectTokenProvider() {
            if (this.subjectTokenProviderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.subjectTokenProviderBuildStage == 0) {
                this.subjectTokenProviderBuildStage = (byte)-1;
                this.subjectTokenProvider = Objects.requireNonNull(ImmutableTokenExchangeConfig.this.getSubjectTokenProviderInitialize(), "subjectTokenProvider");
                this.subjectTokenProviderBuildStage = 1;
            }
            return this.subjectTokenProvider;
        }

        void subjectTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> subjectTokenProvider) {
            this.subjectTokenProvider = subjectTokenProvider;
            this.subjectTokenProviderBuildStage = 1;
        }

        BiFunction<AccessToken, RefreshToken, TypedToken> getActorTokenProvider() {
            if (this.actorTokenProviderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.actorTokenProviderBuildStage == 0) {
                this.actorTokenProviderBuildStage = (byte)-1;
                this.actorTokenProvider = Objects.requireNonNull(ImmutableTokenExchangeConfig.this.getActorTokenProviderInitialize(), "actorTokenProvider");
                this.actorTokenProviderBuildStage = 1;
            }
            return this.actorTokenProvider;
        }

        void actorTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> actorTokenProvider) {
            this.actorTokenProvider = actorTokenProvider;
            this.actorTokenProviderBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.requestedTokenTypeBuildStage == -1) {
                attributes.add("requestedTokenType");
            }
            if (this.subjectTokenProviderBuildStage == -1) {
                attributes.add("subjectTokenProvider");
            }
            if (this.actorTokenProviderBuildStage == -1) {
                attributes.add("actorTokenProvider");
            }
            return "Cannot build TokenExchangeConfig, attribute initializers form cycle " + String.valueOf(attributes);
        }
    }

    @Generated(from="TokenExchangeConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements TokenExchangeConfig.Builder {
        @Nullable
        private URI requestedTokenType;
        @Nullable
        private URI resource;
        @Nullable
        private String audience;
        @Nullable
        private BiFunction<AccessToken, RefreshToken, TypedToken> subjectTokenProvider;
        @Nullable
        private BiFunction<AccessToken, RefreshToken, TypedToken> actorTokenProvider;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TokenExchangeConfig instance) {
            Optional<String> audienceOptional;
            Objects.requireNonNull(instance, "instance");
            this.requestedTokenType(instance.getRequestedTokenType());
            Optional<URI> resourceOptional = instance.getResource();
            if (resourceOptional.isPresent()) {
                this.resource(resourceOptional);
            }
            if ((audienceOptional = instance.getAudience()).isPresent()) {
                this.audience(audienceOptional);
            }
            this.subjectTokenProvider((BiFunction)instance.getSubjectTokenProvider());
            this.actorTokenProvider((BiFunction)instance.getActorTokenProvider());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder requestedTokenType(URI requestedTokenType) {
            this.requestedTokenType = Objects.requireNonNull(requestedTokenType, "requestedTokenType");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder resource(URI resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder resource(Optional<? extends URI> resource) {
            this.resource = resource.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder audience(String audience) {
            this.audience = Objects.requireNonNull(audience, "audience");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder audience(Optional<String> audience) {
            this.audience = audience.orElse(null);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder subjectTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> subjectTokenProvider) {
            this.subjectTokenProvider = Objects.requireNonNull(subjectTokenProvider, "subjectTokenProvider");
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder actorTokenProvider(BiFunction<AccessToken, RefreshToken, TypedToken> actorTokenProvider) {
            this.actorTokenProvider = Objects.requireNonNull(actorTokenProvider, "actorTokenProvider");
            return this;
        }

        @Override
        public ImmutableTokenExchangeConfig build() {
            return new ImmutableTokenExchangeConfig(this);
        }
    }
}

