/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.iceberg.ContentFile;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

public class PartitionStats
implements StructLike {
    private static final int STATS_COUNT = 12;
    private StructLike partition;
    private int specId;
    private long dataRecordCount;
    private int dataFileCount;
    private long totalDataFileSizeInBytes;
    private long positionDeleteRecordCount;
    private int positionDeleteFileCount;
    private long equalityDeleteRecordCount;
    private int equalityDeleteFileCount;
    private long totalRecordCount;
    private Long lastUpdatedAt;
    private Long lastUpdatedSnapshotId;

    public PartitionStats(StructLike partition, int specId) {
        this.partition = partition;
        this.specId = specId;
    }

    public StructLike partition() {
        return this.partition;
    }

    public int specId() {
        return this.specId;
    }

    public long dataRecordCount() {
        return this.dataRecordCount;
    }

    public int dataFileCount() {
        return this.dataFileCount;
    }

    public long totalDataFileSizeInBytes() {
        return this.totalDataFileSizeInBytes;
    }

    public long positionDeleteRecordCount() {
        return this.positionDeleteRecordCount;
    }

    public int positionDeleteFileCount() {
        return this.positionDeleteFileCount;
    }

    public long equalityDeleteRecordCount() {
        return this.equalityDeleteRecordCount;
    }

    public int equalityDeleteFileCount() {
        return this.equalityDeleteFileCount;
    }

    public long totalRecordCount() {
        return this.totalRecordCount;
    }

    public Long lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Long lastUpdatedSnapshotId() {
        return this.lastUpdatedSnapshotId;
    }

    public void liveEntry(ContentFile<?> file, Snapshot snapshot) {
        Preconditions.checkArgument(this.specId == file.specId(), "Spec IDs must match");
        switch (file.content()) {
            case DATA: {
                this.dataRecordCount += file.recordCount();
                ++this.dataFileCount;
                this.totalDataFileSizeInBytes += file.fileSizeInBytes();
                break;
            }
            case POSITION_DELETES: {
                this.positionDeleteRecordCount += file.recordCount();
                ++this.positionDeleteFileCount;
                break;
            }
            case EQUALITY_DELETES: {
                this.equalityDeleteRecordCount += file.recordCount();
                ++this.equalityDeleteFileCount;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported file content type: " + file.content());
            }
        }
        if (snapshot != null) {
            this.updateSnapshotInfo(snapshot.snapshotId(), snapshot.timestampMillis());
        }
    }

    public void deletedEntry(Snapshot snapshot) {
        if (snapshot != null) {
            this.updateSnapshotInfo(snapshot.snapshotId(), snapshot.timestampMillis());
        }
    }

    public void appendStats(PartitionStats entry) {
        Preconditions.checkArgument(this.specId == entry.specId(), "Spec IDs must match");
        this.dataRecordCount += entry.dataRecordCount;
        this.dataFileCount += entry.dataFileCount;
        this.totalDataFileSizeInBytes += entry.totalDataFileSizeInBytes;
        this.positionDeleteRecordCount += entry.positionDeleteRecordCount;
        this.positionDeleteFileCount += entry.positionDeleteFileCount;
        this.equalityDeleteRecordCount += entry.equalityDeleteRecordCount;
        this.equalityDeleteFileCount += entry.equalityDeleteFileCount;
        this.totalRecordCount += entry.totalRecordCount;
        if (entry.lastUpdatedAt != null) {
            this.updateSnapshotInfo(entry.lastUpdatedSnapshotId, entry.lastUpdatedAt);
        }
    }

    private void updateSnapshotInfo(long snapshotId, long updatedAt) {
        if (this.lastUpdatedAt == null || this.lastUpdatedAt < updatedAt) {
            this.lastUpdatedAt = updatedAt;
            this.lastUpdatedSnapshotId = snapshotId;
        }
    }

    @Override
    public int size() {
        return 12;
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        switch (pos) {
            case 0: {
                return javaClass.cast(this.partition);
            }
            case 1: {
                return javaClass.cast(this.specId);
            }
            case 2: {
                return javaClass.cast(this.dataRecordCount);
            }
            case 3: {
                return javaClass.cast(this.dataFileCount);
            }
            case 4: {
                return javaClass.cast(this.totalDataFileSizeInBytes);
            }
            case 5: {
                return javaClass.cast(this.positionDeleteRecordCount);
            }
            case 6: {
                return javaClass.cast(this.positionDeleteFileCount);
            }
            case 7: {
                return javaClass.cast(this.equalityDeleteRecordCount);
            }
            case 8: {
                return javaClass.cast(this.equalityDeleteFileCount);
            }
            case 9: {
                return javaClass.cast(this.totalRecordCount);
            }
            case 10: {
                return javaClass.cast(this.lastUpdatedAt);
            }
            case 11: {
                return javaClass.cast(this.lastUpdatedSnapshotId);
            }
        }
        throw new UnsupportedOperationException("Unknown position: " + pos);
    }

    @Override
    public <T> void set(int pos, T value) {
        switch (pos) {
            case 0: {
                this.partition = (StructLike)value;
                break;
            }
            case 1: {
                this.specId = (Integer)value;
                break;
            }
            case 2: {
                this.dataRecordCount = (Long)value;
                break;
            }
            case 3: {
                this.dataFileCount = (Integer)value;
                break;
            }
            case 4: {
                this.totalDataFileSizeInBytes = (Long)value;
                break;
            }
            case 5: {
                this.positionDeleteRecordCount = value == null ? 0L : (Long)value;
                break;
            }
            case 6: {
                this.positionDeleteFileCount = value == null ? 0 : (Integer)value;
                break;
            }
            case 7: {
                this.equalityDeleteRecordCount = value == null ? 0L : (Long)value;
                break;
            }
            case 8: {
                this.equalityDeleteFileCount = value == null ? 0 : (Integer)value;
                break;
            }
            case 9: {
                this.totalRecordCount = value == null ? 0L : (Long)value;
                break;
            }
            case 10: {
                this.lastUpdatedAt = (Long)value;
                break;
            }
            case 11: {
                this.lastUpdatedSnapshotId = (Long)value;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown position: " + pos);
            }
        }
    }
}

