/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.actions;

import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iceberg.ContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.RewriteJobOrder;
import org.apache.iceberg.actions.ImmutableRewriteDataFiles;
import org.apache.iceberg.actions.RewriteDataFiles;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.DataFileSet;

public class RewriteFileGroup {
    private final RewriteDataFiles.FileGroupInfo info;
    private final List<FileScanTask> fileScanTasks;
    private DataFileSet addedFiles = DataFileSet.create();

    public RewriteFileGroup(RewriteDataFiles.FileGroupInfo info, List<FileScanTask> fileScanTasks) {
        this.info = info;
        this.fileScanTasks = fileScanTasks;
    }

    public RewriteDataFiles.FileGroupInfo info() {
        return this.info;
    }

    public List<FileScanTask> fileScans() {
        return this.fileScanTasks;
    }

    public void setOutputFiles(Set<DataFile> files) {
        this.addedFiles = DataFileSet.of(files);
    }

    public Set<DataFile> rewrittenFiles() {
        return this.fileScans().stream().map(ContentScanTask::file).collect(Collectors.toCollection(DataFileSet::create));
    }

    public Set<DataFile> addedFiles() {
        return this.addedFiles;
    }

    public RewriteDataFiles.FileGroupRewriteResult asResult() {
        Preconditions.checkState(this.addedFiles != null, "Cannot get result, Group was never rewritten");
        return ImmutableRewriteDataFiles.FileGroupRewriteResult.builder().info(this.info).addedDataFilesCount(this.addedFiles.size()).rewrittenDataFilesCount(this.fileScanTasks.size()).rewrittenBytesCount(this.sizeInBytes()).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("info", this.info).add("numRewrittenFiles", this.fileScanTasks.size()).add("numAddedFiles", this.addedFiles == null ? "Rewrite Incomplete" : Integer.toString(this.addedFiles.size())).add("numRewrittenBytes", this.sizeInBytes()).toString();
    }

    public long sizeInBytes() {
        return this.fileScanTasks.stream().mapToLong(ContentScanTask::length).sum();
    }

    public int numFiles() {
        return this.fileScanTasks.size();
    }

    public static Comparator<RewriteFileGroup> comparator(RewriteJobOrder rewriteJobOrder) {
        switch (rewriteJobOrder) {
            case BYTES_ASC: {
                return Comparator.comparing(RewriteFileGroup::sizeInBytes);
            }
            case BYTES_DESC: {
                return Comparator.comparing(RewriteFileGroup::sizeInBytes, Comparator.reverseOrder());
            }
            case FILES_ASC: {
                return Comparator.comparing(RewriteFileGroup::numFiles);
            }
            case FILES_DESC: {
                return Comparator.comparing(RewriteFileGroup::numFiles, Comparator.reverseOrder());
            }
        }
        return (unused, unused2) -> 0;
    }
}

