/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aliyun.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectRequest;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.apache.iceberg.aliyun.AliyunProperties;
import org.apache.iceberg.aliyun.oss.OSSURI;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.metrics.Counter;
import org.apache.iceberg.metrics.MetricsContext;
import org.apache.iceberg.relocated.com.google.common.base.Joiner;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSSOutputStream
extends PositionOutputStream {
    private static final Logger LOG = LoggerFactory.getLogger(OSSOutputStream.class);
    private final StackTraceElement[] createStack;
    private final OSS client;
    private final OSSURI uri;
    private final File currentStagingFile;
    private final OutputStream stream;
    private long pos = 0L;
    private boolean closed = false;
    private final Counter writeBytes;
    private final Counter writeOperations;

    OSSOutputStream(OSS client, OSSURI uri, AliyunProperties aliyunProperties, MetricsContext metrics) {
        this.client = client;
        this.uri = uri;
        this.createStack = Thread.currentThread().getStackTrace();
        this.currentStagingFile = OSSOutputStream.newStagingFile(aliyunProperties.ossStagingDirectory());
        this.stream = OSSOutputStream.newStream(this.currentStagingFile);
        this.writeBytes = metrics.counter("write.bytes", MetricsContext.Unit.BYTES);
        this.writeOperations = metrics.counter("write.operations");
    }

    private static File newStagingFile(String ossStagingDirectory) {
        try {
            File stagingFile = File.createTempFile("oss-file-io-", ".tmp", new File(ossStagingDirectory));
            stagingFile.deleteOnExit();
            return stagingFile;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static OutputStream newStream(File currentStagingFile) {
        try {
            return new BufferedOutputStream(new FileOutputStream(currentStagingFile));
        }
        catch (FileNotFoundException e) {
            throw new NotFoundException(e, "Failed to create file: %s", currentStagingFile);
        }
    }

    private static InputStream uncheckedInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getPos() {
        return this.pos;
    }

    @Override
    public void flush() throws IOException {
        Preconditions.checkState(!this.closed, "Already closed.");
        this.stream.flush();
    }

    @Override
    public void write(int b) throws IOException {
        Preconditions.checkState(!this.closed, "Already closed.");
        this.stream.write(b);
        ++this.pos;
        this.writeBytes.increment();
        this.writeOperations.increment();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Preconditions.checkState(!this.closed, "Already closed.");
        this.stream.write(b, off, len);
        this.pos += (long)len;
        this.writeBytes.increment(len);
        this.writeOperations.increment();
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        super.close();
        this.closed = true;
        try {
            this.stream.close();
            this.completeUploads();
        }
        finally {
            this.cleanUpStagingFiles();
        }
    }

    private void completeUploads() {
        long contentLength = this.currentStagingFile.length();
        if (contentLength == 0L) {
            LOG.debug("Skipping empty upload to OSS");
            return;
        }
        LOG.debug("Uploading {} staged bytes to OSS", (Object)contentLength);
        InputStream contentStream = OSSOutputStream.uncheckedInputStream(this.currentStagingFile);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(contentLength);
        PutObjectRequest request = new PutObjectRequest(this.uri.bucket(), this.uri.key(), contentStream, metadata);
        this.client.putObject(request);
    }

    private void cleanUpStagingFiles() {
        if (!this.currentStagingFile.delete()) {
            LOG.warn("Failed to delete staging file: {}", (Object)this.currentStagingFile);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.closed) {
            this.close();
            String trace = Joiner.on("\n\t").join(Arrays.copyOfRange(this.createStack, 1, this.createStack.length));
            LOG.warn("Unclosed output stream created by:\n\t{}", (Object)trace);
        }
    }
}

