/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.adlsv2;

import com.azure.storage.file.datalake.DataLakeFileClient;
import org.apache.iceberg.azure.AzureProperties;
import org.apache.iceberg.azure.adlsv2.ADLSInputStream;
import org.apache.iceberg.azure.adlsv2.BaseADLSFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.metrics.MetricsContext;

class ADLSInputFile
extends BaseADLSFile
implements InputFile {
    private Long fileSize;

    ADLSInputFile(String location, DataLakeFileClient fileClient, AzureProperties azureProperties, MetricsContext metrics) {
        this(location, null, fileClient, azureProperties, metrics);
    }

    ADLSInputFile(String location, Long fileSize, DataLakeFileClient fileClient, AzureProperties azureProperties, MetricsContext metrics) {
        super(location, fileClient, azureProperties, metrics);
        this.fileSize = fileSize != null && fileSize > 0L ? fileSize : null;
    }

    @Override
    public long getLength() {
        if (this.fileSize == null) {
            this.fileSize = this.fileClient().getProperties().getFileSize();
        }
        return this.fileSize;
    }

    @Override
    public SeekableInputStream newStream() {
        return new ADLSInputStream(this.fileClient(), this.fileSize, this.azureProperties(), this.metrics());
    }
}

