/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.adlsv2;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;

class ADLSLocation {
    private static final Pattern URI_PATTERN = Pattern.compile("^abfss?://([^/?#]+)(.*)?$");
    private final String storageAccount;
    private final String container;
    private final String path;

    ADLSLocation(String location) {
        Preconditions.checkArgument(location != null, "Invalid location: null");
        Matcher matcher = URI_PATTERN.matcher(location);
        ValidationException.check(matcher.matches(), "Invalid ADLS URI: %s", location);
        String authority = matcher.group(1);
        String[] parts = authority.split("@", -1);
        if (parts.length > 1) {
            this.container = parts[0];
            this.storageAccount = parts[1];
        } else {
            this.container = null;
            this.storageAccount = authority;
        }
        String uriPath = matcher.group(2);
        this.path = uriPath == null ? "" : (uriPath.startsWith("/") ? uriPath.substring(1) : uriPath);
    }

    public String storageAccount() {
        return this.storageAccount;
    }

    public Optional<String> container() {
        return Optional.ofNullable(this.container);
    }

    public String path() {
        return this.path;
    }
}

