/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.List;
import org.apache.iceberg.avro.ValueWriter;
import org.apache.iceberg.avro.ValueWriters;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.shaded.org.apache.avro.io.Encoder;

class GenericWriters {
    private static final OffsetDateTime EPOCH = Instant.ofEpochSecond(0L).atOffset(ZoneOffset.UTC);
    private static final LocalDate EPOCH_DAY = EPOCH.toLocalDate();

    private GenericWriters() {
    }

    static ValueWriter<LocalDate> dates() {
        return DateWriter.INSTANCE;
    }

    static ValueWriter<LocalTime> times() {
        return TimeWriter.INSTANCE;
    }

    static ValueWriter<LocalDateTime> timestamps() {
        return TimestampWriter.INSTANCE;
    }

    static ValueWriter<OffsetDateTime> timestamptz() {
        return TimestamptzWriter.INSTANCE;
    }

    static ValueWriter<Record> struct(List<ValueWriter<?>> writers) {
        return new GenericRecordWriter(writers);
    }

    private static class GenericRecordWriter
    extends ValueWriters.StructWriter<Record> {
        private GenericRecordWriter(List<ValueWriter<?>> writers) {
            super(writers);
        }

        @Override
        protected Object get(Record struct, int pos) {
            return struct.get(pos);
        }
    }

    private static class TimestamptzWriter
    implements ValueWriter<OffsetDateTime> {
        private static final TimestamptzWriter INSTANCE = new TimestamptzWriter();

        private TimestamptzWriter() {
        }

        @Override
        public void write(OffsetDateTime timestamptz, Encoder encoder) throws IOException {
            encoder.writeLong(ChronoUnit.MICROS.between(EPOCH, timestamptz));
        }
    }

    private static class TimestampWriter
    implements ValueWriter<LocalDateTime> {
        private static final TimestampWriter INSTANCE = new TimestampWriter();

        private TimestampWriter() {
        }

        @Override
        public void write(LocalDateTime timestamp, Encoder encoder) throws IOException {
            encoder.writeLong(ChronoUnit.MICROS.between(EPOCH, timestamp.atOffset(ZoneOffset.UTC)));
        }
    }

    private static class TimeWriter
    implements ValueWriter<LocalTime> {
        private static final TimeWriter INSTANCE = new TimeWriter();

        private TimeWriter() {
        }

        @Override
        public void write(LocalTime time, Encoder encoder) throws IOException {
            encoder.writeLong(time.toNanoOfDay() / 1000L);
        }
    }

    private static class DateWriter
    implements ValueWriter<LocalDate> {
        private static final DateWriter INSTANCE = new DateWriter();

        private DateWriter() {
        }

        @Override
        public void write(LocalDate date, Encoder encoder) throws IOException {
            encoder.writeInt((int)ChronoUnit.DAYS.between(EPOCH_DAY, date));
        }
    }
}

