/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.List;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.iceberg.relocated.com.google.common.base.Splitter;

public enum HiveVersion {
    HIVE_4(4),
    HIVE_3(3),
    HIVE_2(2),
    HIVE_1_2(1),
    NOT_SUPPORTED(0);

    private final int order;
    private static final HiveVersion CURRENT;

    private HiveVersion(int order) {
        this.order = order;
    }

    public static HiveVersion current() {
        return CURRENT;
    }

    public static boolean min(HiveVersion other) {
        return HiveVersion.CURRENT.order >= other.order;
    }

    private static HiveVersion calculate() {
        String version = HiveVersionInfo.getShortVersion();
        List<String> versions = Splitter.on('.').splitToList(version);
        switch (versions.get(0)) {
            case "4": {
                return HIVE_4;
            }
            case "3": {
                return HIVE_3;
            }
            case "2": {
                return HIVE_2;
            }
            case "1": {
                if (versions.get(1).equals("2")) {
                    return HIVE_1_2;
                }
                return NOT_SUPPORTED;
            }
        }
        return NOT_SUPPORTED;
    }

    static {
        CURRENT = HiveVersion.calculate();
    }
}

