/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.PartitionedFanoutWriter;
import org.apache.iceberg.mr.mapred.Container;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HiveIcebergRecordWriter
extends PartitionedFanoutWriter<Record>
implements FileSinkOperator.RecordWriter,
RecordWriter<NullWritable, Container<Record>> {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIcebergRecordWriter.class);
    private final PartitionKey currentKey;
    private final FileIO io;
    private final InternalRecordWrapper wrapper;
    private static final Map<TaskAttemptID, Map<String, HiveIcebergRecordWriter>> WRITERS = Maps.newConcurrentMap();

    static Map<String, HiveIcebergRecordWriter> removeWriters(TaskAttemptID taskAttemptID) {
        return WRITERS.remove(taskAttemptID);
    }

    static Map<String, HiveIcebergRecordWriter> getWriters(TaskAttemptID taskAttemptID) {
        return WRITERS.get(taskAttemptID);
    }

    HiveIcebergRecordWriter(Schema schema, PartitionSpec spec, FileFormat format, FileAppenderFactory<Record> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, TaskAttemptID taskAttemptID, String tableName) {
        super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
        this.io = io;
        this.currentKey = new PartitionKey(spec, schema);
        this.wrapper = new InternalRecordWrapper(schema.asStruct());
        WRITERS.putIfAbsent(taskAttemptID, Maps.newConcurrentMap());
        WRITERS.get(taskAttemptID).put(tableName, this);
    }

    @Override
    protected PartitionKey partition(Record row) {
        this.currentKey.partition(this.wrapper.wrap(row));
        return this.currentKey;
    }

    @Override
    public void write(Writable row) throws IOException {
        super.write((Record)((Container)row).get());
    }

    public void write(NullWritable key, Container value) throws IOException {
        this.write(value);
    }

    public void close(boolean abort) throws IOException {
        DataFile[] dataFiles = super.dataFiles();
        if (abort) {
            Tasks.foreach(dataFiles).executeWith(ThreadPools.getWorkerPool()).retry(3).suppressFailureWhenFinished().onFailure((file, exception) -> LOG.debug("Failed on to remove file {} on abort", file, (Object)exception)).run(dataFile -> this.io.deleteFile(dataFile.path().toString()));
        }
        LOG.info("IcebergRecordWriter is closed with abort={}. Created {} files", (Object)abort, (Object)dataFiles.length);
    }

    public void close(Reporter reporter) throws IOException {
        this.close(false);
    }
}

