/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.requests;

import java.io.IOException;
import java.util.Locale;
import org.apache.iceberg.metrics.CommitReport;
import org.apache.iceberg.metrics.CommitReportParser;
import org.apache.iceberg.metrics.ScanReport;
import org.apache.iceberg.metrics.ScanReportParser;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.requests.ImmutableReportMetricsRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.shaded.com.fasterxml.jackson.databind.JsonNode;
import org.apache.iceberg.util.JsonUtil;

public class ReportMetricsRequestParser {
    private static final String REPORT_TYPE = "report-type";

    private ReportMetricsRequestParser() {
    }

    public static String toJson(ReportMetricsRequest request) {
        return ReportMetricsRequestParser.toJson(request, false);
    }

    public static String toJson(ReportMetricsRequest request, boolean pretty) {
        return JsonUtil.generate(gen -> ReportMetricsRequestParser.toJson(request, gen), pretty);
    }

    public static void toJson(ReportMetricsRequest request, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument(null != request, "Invalid metrics request: null");
        gen.writeStartObject();
        gen.writeStringField(REPORT_TYPE, ReportMetricsRequestParser.fromReportType(request.reportType()));
        if (ReportMetricsRequest.ReportType.SCAN_REPORT == request.reportType()) {
            ScanReportParser.toJsonWithoutStartEnd((ScanReport)request.report(), gen);
        }
        if (ReportMetricsRequest.ReportType.COMMIT_REPORT == request.reportType()) {
            CommitReportParser.toJsonWithoutStartEnd((CommitReport)request.report(), gen);
        }
        gen.writeEndObject();
    }

    private static String fromReportType(ReportMetricsRequest.ReportType reportType) {
        return reportType.name().replaceAll("_", "-").toLowerCase(Locale.ENGLISH);
    }

    private static ReportMetricsRequest.ReportType toReportType(String type) {
        return ReportMetricsRequest.ReportType.fromString(type.replaceAll("-", "_"));
    }

    public static ReportMetricsRequest fromJson(String json) {
        return JsonUtil.parse(json, ReportMetricsRequestParser::fromJson);
    }

    public static ReportMetricsRequest fromJson(JsonNode json) {
        Preconditions.checkArgument(null != json, "Cannot parse metrics request from null object");
        Preconditions.checkArgument(json.isObject(), "Cannot parse metrics request from non-object: %s", (Object)json);
        ReportMetricsRequest.ReportType type = ReportMetricsRequestParser.toReportType(JsonUtil.getString(REPORT_TYPE, json));
        if (ReportMetricsRequest.ReportType.SCAN_REPORT == type) {
            return ImmutableReportMetricsRequest.builder().reportType(type).report(ScanReportParser.fromJson(json)).build();
        }
        if (ReportMetricsRequest.ReportType.COMMIT_REPORT == type) {
            return ImmutableReportMetricsRequest.builder().reportType(type).report(CommitReportParser.fromJson(json)).build();
        }
        return ReportMetricsRequest.unknown();
    }
}

