/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.rest.credentials.Credential;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import org.apache.iceberg.shaded.com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="LoadCredentialsResponse", generator="Immutables")
@Immutable
public final class ImmutableLoadCredentialsResponse
implements LoadCredentialsResponse {
    private final List<Credential> credentials;

    private ImmutableLoadCredentialsResponse(List<Credential> credentials) {
        this.credentials = credentials;
    }

    @Override
    public List<Credential> credentials() {
        return this.credentials;
    }

    public final ImmutableLoadCredentialsResponse withCredentials(Credential ... elements) {
        List<Credential> newValue = ImmutableLoadCredentialsResponse.createUnmodifiableList(false, ImmutableLoadCredentialsResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableLoadCredentialsResponse(newValue);
    }

    public final ImmutableLoadCredentialsResponse withCredentials(Iterable<? extends Credential> elements) {
        if (this.credentials == elements) {
            return this;
        }
        List<Credential> newValue = ImmutableLoadCredentialsResponse.createUnmodifiableList(false, ImmutableLoadCredentialsResponse.createSafeList(elements, true, false));
        return new ImmutableLoadCredentialsResponse(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableLoadCredentialsResponse && this.equalTo(0, (ImmutableLoadCredentialsResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableLoadCredentialsResponse another) {
        return this.credentials.equals(another.credentials);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.credentials.hashCode();
        return h2;
    }

    public String toString() {
        return "LoadCredentialsResponse{credentials=" + this.credentials + "}";
    }

    public static ImmutableLoadCredentialsResponse copyOf(LoadCredentialsResponse instance) {
        if (instance instanceof ImmutableLoadCredentialsResponse) {
            return (ImmutableLoadCredentialsResponse)instance;
        }
        return ImmutableLoadCredentialsResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="LoadCredentialsResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<Credential> credentials = new ArrayList<Credential>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(LoadCredentialsResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllCredentials(instance.credentials());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCredentials(Credential element) {
            this.credentials.add(Objects.requireNonNull(element, "credentials element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addCredentials(Credential ... elements) {
            for (Credential element : elements) {
                this.credentials.add(Objects.requireNonNull(element, "credentials element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder credentials(Iterable<? extends Credential> elements) {
            this.credentials.clear();
            return this.addAllCredentials(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllCredentials(Iterable<? extends Credential> elements) {
            for (Credential credential : elements) {
                this.credentials.add(Objects.requireNonNull(credential, "credentials element"));
            }
            return this;
        }

        public ImmutableLoadCredentialsResponse build() {
            return new ImmutableLoadCredentialsResponse(ImmutableLoadCredentialsResponse.createUnmodifiableList(true, this.credentials));
        }
    }
}

