/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.orc.impl;

import java.lang.reflect.InvocationTargetException;
import org.apache.hadoop.util.VersionInfo;
import org.apache.iceberg.shaded.org.apache.orc.impl.HadoopShims;
import org.apache.iceberg.shaded.org.apache.orc.impl.HadoopShimsPre2_3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopShimsFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopShimsFactory.class);
    private static final String CURRENT_SHIM_NAME = "org.apache.iceberg.shaded.org.apache.orc.impl.HadoopShimsCurrent";
    private static final String PRE_2_6_SHIM_NAME = "org.apache.iceberg.shaded.org.apache.orc.impl.HadoopShimsPre2_6";
    private static final String PRE_2_7_SHIM_NAME = "org.apache.iceberg.shaded.org.apache.orc.impl.HadoopShimsPre2_7";
    private static HadoopShims SHIMS = null;

    private static HadoopShims createShimByName(String name) {
        try {
            Class<?> cls = Class.forName(name);
            return (HadoopShims)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException("Can't create shims for " + name, e);
        }
    }

    public static synchronized HadoopShims get() {
        if (SHIMS == null) {
            String[] versionParts = VersionInfo.getVersion().split("[.]");
            int major = Integer.parseInt(versionParts[0]);
            int minor = Integer.parseInt(versionParts[1]);
            if (major < 2 || major == 2 && minor < 7) {
                LOG.warn("Hadoop " + VersionInfo.getVersion() + " support is deprecated. Please upgrade to Hadoop 2.7.3 or above.");
            }
            SHIMS = major < 2 || major == 2 && minor < 3 ? new HadoopShimsPre2_3() : (major == 2 && minor < 6 ? HadoopShimsFactory.createShimByName(PRE_2_6_SHIM_NAME) : (major == 2 && minor < 7 ? HadoopShimsFactory.createShimByName(PRE_2_7_SHIM_NAME) : HadoopShimsFactory.createShimByName(CURRENT_SHIM_NAME)));
        }
        return SHIMS;
    }
}

