/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.shaded.org.apache.parquet.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.iceberg.shaded.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.iceberg.shaded.org.apache.parquet.schema.MessageType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.OriginalType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.PrimitiveType;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Type;
import org.apache.iceberg.shaded.org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTypeParser {
    private static final Logger LOG = LoggerFactory.getLogger(MessageTypeParser.class);

    private MessageTypeParser() {
    }

    public static MessageType parseMessageType(String input) {
        return MessageTypeParser.parse(input);
    }

    private static MessageType parse(String schemaString) {
        Tokenizer st = new Tokenizer(schemaString, " ;{}()\n\t");
        Types.MessageTypeBuilder builder = Types.buildMessage();
        String t2 = st.nextToken();
        MessageTypeParser.check(t2, "message", "start with 'message'", st);
        String name = st.nextToken();
        MessageTypeParser.addGroupTypeFields(st.nextToken(), st, builder);
        return builder.named(name);
    }

    private static void addGroupTypeFields(String t2, Tokenizer st, Types.GroupBuilder builder) {
        MessageTypeParser.check(t2, "{", "start of message", st);
        while (!(t2 = st.nextToken()).equals("}")) {
            MessageTypeParser.addType(t2, st, builder);
        }
    }

    private static void addType(String t2, Tokenizer st, Types.GroupBuilder builder) {
        Type.Repetition repetition = MessageTypeParser.asRepetition(t2, st);
        String type = st.nextToken();
        if ("group".equalsIgnoreCase(type)) {
            MessageTypeParser.addGroupType(st, repetition, builder);
        } else {
            MessageTypeParser.addPrimitiveType(st, MessageTypeParser.asPrimitive(type, st), repetition, builder);
        }
    }

    private static void addGroupType(Tokenizer st, Type.Repetition r, Types.GroupBuilder<?> builder) {
        Types.GroupBuilder childBuilder = builder.group(r);
        String name = st.nextToken();
        String t2 = st.nextToken();
        OriginalType originalType = null;
        if (t2.equalsIgnoreCase("(")) {
            originalType = OriginalType.valueOf(st.nextToken());
            childBuilder.as(originalType);
            MessageTypeParser.check(st.nextToken(), ")", "original type ended by )", st);
            t2 = st.nextToken();
        }
        if (t2.equals("=")) {
            childBuilder.id(Integer.parseInt(st.nextToken()));
            t2 = st.nextToken();
        }
        try {
            MessageTypeParser.addGroupTypeFields(t2, st, childBuilder);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("problem reading type: type = group, name = " + name + ", original type = " + (Object)((Object)originalType), e);
        }
        childBuilder.named(name);
    }

    private static void addPrimitiveType(Tokenizer st, PrimitiveType.PrimitiveTypeName type, Type.Repetition r, Types.GroupBuilder<?> builder) {
        String t2;
        Types.PrimitiveBuilder childBuilder = builder.primitive(type, r);
        if (type == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
            t2 = st.nextToken();
            if (!t2.equalsIgnoreCase("(")) {
                throw new IllegalArgumentException("expecting (length) for field of type fixed_len_byte_array");
            }
            childBuilder.length(Integer.parseInt(st.nextToken()));
            MessageTypeParser.check(st.nextToken(), ")", "type length ended by )", st);
        }
        String name = st.nextToken();
        t2 = st.nextToken();
        OriginalType originalType = null;
        if (t2.equalsIgnoreCase("(")) {
            t2 = st.nextToken();
            if (MessageTypeParser.isLogicalType(t2)) {
                LogicalTypeAnnotation.LogicalTypeToken logicalType = LogicalTypeAnnotation.LogicalTypeToken.valueOf(t2);
                t2 = st.nextToken();
                ArrayList<String> tokens = new ArrayList<String>();
                if ("(".equals(t2)) {
                    while (!")".equals(t2)) {
                        if (!(",".equals(t2) || "(".equals(t2) || ")".equals(t2))) {
                            tokens.add(t2);
                        }
                        t2 = st.nextToken();
                    }
                    t2 = st.nextToken();
                }
                LogicalTypeAnnotation logicalTypeAnnotation = logicalType.fromString(tokens);
                childBuilder.as(logicalTypeAnnotation);
            } else {
                originalType = OriginalType.valueOf(t2);
                childBuilder.as(originalType);
                if (OriginalType.DECIMAL == originalType) {
                    t2 = st.nextToken();
                    if (t2.equalsIgnoreCase("(")) {
                        childBuilder.precision(Integer.parseInt(st.nextToken()));
                        t2 = st.nextToken();
                        if (t2.equalsIgnoreCase(",")) {
                            childBuilder.scale(Integer.parseInt(st.nextToken()));
                            t2 = st.nextToken();
                        }
                        MessageTypeParser.check(t2, ")", "decimal type ended by )", st);
                        t2 = st.nextToken();
                    }
                } else {
                    t2 = st.nextToken();
                }
            }
            MessageTypeParser.check(t2, ")", "logical type ended by )", st);
            t2 = st.nextToken();
        }
        if (t2.equals("=")) {
            childBuilder.id(Integer.parseInt(st.nextToken()));
            t2 = st.nextToken();
        }
        MessageTypeParser.check(t2, ";", "field ended by ';'", st);
        try {
            childBuilder.named(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("problem reading type: type = " + (Object)((Object)type) + ", name = " + name + ", original type = " + (Object)((Object)originalType), e);
        }
    }

    private static boolean isLogicalType(String t2) {
        return Arrays.stream(LogicalTypeAnnotation.LogicalTypeToken.values()).anyMatch(type -> type.name().equals(t2));
    }

    private static PrimitiveType.PrimitiveTypeName asPrimitive(String t2, Tokenizer st) {
        try {
            return PrimitiveType.PrimitiveTypeName.valueOf(t2.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("expected one of " + Arrays.toString((Object[])PrimitiveType.PrimitiveTypeName.values()) + " got " + t2 + " at " + st.getLocationString(), e);
        }
    }

    private static Type.Repetition asRepetition(String t2, Tokenizer st) {
        try {
            return Type.Repetition.valueOf(t2.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("expected one of " + Arrays.toString((Object[])Type.Repetition.values()) + " got " + t2 + " at " + st.getLocationString(), e);
        }
    }

    private static void check(String t2, String expected, String message, Tokenizer tokenizer) {
        if (!t2.equalsIgnoreCase(expected)) {
            throw new IllegalArgumentException(message + ": expected '" + expected + "' but got '" + t2 + "' at " + tokenizer.getLocationString());
        }
    }

    private static class Tokenizer {
        private StringTokenizer st;
        private int line = 0;
        private StringBuilder currentLine = new StringBuilder();

        public Tokenizer(String schemaString, String string) {
            this.st = new StringTokenizer(schemaString, " ,;{}()\n\t=", true);
        }

        public String nextToken() {
            while (this.st.hasMoreTokens()) {
                String t2 = this.st.nextToken();
                if (t2.equals("\n")) {
                    ++this.line;
                    this.currentLine.setLength(0);
                } else {
                    this.currentLine.append(t2);
                }
                if (this.isWhitespace(t2)) continue;
                return t2;
            }
            throw new IllegalArgumentException("unexpected end of schema");
        }

        private boolean isWhitespace(String t2) {
            return t2.equals(" ") || t2.equals("\t") || t2.equals("\n");
        }

        public String getLocationString() {
            return "line " + this.line + ": " + this.currentLine.toString();
        }
    }
}

